/*
 * This file is part of IIO, the Industrial IO Library
 * CSIRO Division of Manufacturing Technology
 * $Id: exec.c 365 2003-05-12 02:31:19Z sik057 $
 *
 * exec.c -- generic exec function
 * Robin Kirkham, January 1997
 *
 * This sub-module is intended to be textually included into 
 * one of the os-specific modules 
 */

IIO_STATUS iio_exec(char *format, ...) {
    /*
     * Wrapper for system() using printf-style argument specification.
     * Maybe not the best way, but it will do for now. It is possible
     * to implement this function for vxWorks, whereas standard system()
     * is more difficult
     */
    char line[BUFSIZ];
    va_list ap;
    va_start(ap, format);

    /* format the ommand line */
    vsprintf(line, format, ap);

    /* pass to shell, check return status */ 
    switch (system(line)) {
    case -1:
	return iio_error(NULL);
    case 0:
	return iio_status_ok;
    default:
	return iio_error("External program returned non-zero status");
    }
}
