/*
 * This file is part of IIO, the Industrial IO Library
 * CSIRO Division of Manufacturing Technology
 * $Id: emessage.c 365 2003-05-12 02:31:19Z sik057 $
 *
 * emessage.c -- generic error message function
 * Robin Kirkham, January 1997
 *
 * This sub-module is intended to be textually included into 
 * one of the os-specific modules 
 */

HIDDEN char *iio_emessage = "";

IIO_STATUS iio_emessage_set(char *emessage) {
    /*
     * Set the per-process error message. If the message is NULL,
     * get the message for the current system errno.
     */
    iio_emessage = emessage;

    if (! iio_emessage)
	iio_emessage = strerror(errno);

    if (! iio_emessage)
	iio_emessage = "Invalid errno";

    return iio_status_ok;
}

char *iio_emessage_get(void) {
    /*
     * Return the current error message
     */
    return iio_emessage;
}
