/*
 * This file is part of IIO, the Industrial IO Library
 * CSIRO Division of Manufacturing Technology
 * $Id: decode.c 365 2003-05-12 02:31:19Z sik057 $
 *
 * decode.c -- generic argument decode functions
 * Robin Kirkham, January 1997
 *
 * This sub-module is intended to be textually included into 
 * one of the os-specific modules 
 */

IIO_STATUS iio_decode_long(char *string, long int *result) {
    /*
     * Convert string to long integer decimal. Return error status,
     * but don't log an error if something goes wrong. The end
     * pointer should not point to the start of the string
     * (no number formed) and should point at the end-of-string
     * character, indicating no illegal trailing chars
     */
    char *end = NULL;
    long int value = strtol(string, &end, 0);

    if (end != string && !*end) {
	*result = value;
	return iio_status_ok;
    }
    return iio_error("Illegal characters after numeric");
}

IIO_STATUS iio_decode_double(char *string, double *result) {
    /*
     * Convert string to long integer decimal
     */
    char *end = NULL;
    double value = strtod(string, &end);

    if (end != string && !*end) {
	*result = value;
	return iio_status_ok;
    }
    return iio_error("Illegal characters after numeric");
}
