/*
 * This file is part of IIO, the Industrial IO Library
 * CSIRO Division of Manufacturing Technology
 * $Id: null.c 365 2003-05-12 02:31:19Z sik057 $
 *
 * null.c -- the null channel driver 
 */
#include "internal.h"


HIDDEN IIO_STATUS iio_null_operate(
    IIO_MSTATE *state, IIO_MREG *reg, IIO_OPNODE *opnode, 
    IIO_OP op, unsigned first, unsigned number
) {
    /*
     * The null device accepts all operation codes. The output (if the 
     * operation code has an output) is always zero
     */
    int seqno;

    for (seqno = first; seqno < first + number; ++seqno)
	if (iio_opinfo[op].arg & iio_oparg_out) 
	    iio_data_set(opnode, seqno, 0);

    return iio_status_ok;
}


IIO_STATUS iio_null_init(IIO_MREG *reg, IIO_MSTATE *state) {
    /*
     * There is not really anything to initialise
     */
    return iio_status_ok;
}


IIO_STATUS iio_null_install(IIO_MODULE *module, char *argv[]) {
    /*
     * The null driver accepts no specific arguments. It installs a
     * single widthless channel "null"
     */

    /* register the channel with the channel list */
    return iio_chnode(
	module,
	iio_chtype_null, 0, 1,
	iio_null_operate, NULL
    );
}


IIO_STATUS iio_null(void) {
    /*
     * Register the null driver with IIO, by calling iio_minfo()
     */
    return iio_minfo(
	"null",				/* Our module ID */
	"<null>",			/* Our name */
	"$Revision: 365 $",		/* File RCS ID */
	iio_multi_no,			/* we can be multiply installed */
	iio_null_install,		/* the install function */
	iio_null_init			/* the init function */
    );
}
