/*
 * This file is part of IIO, the Industrial IO Library
 * CSIRO Division of Manufacturing Technology
 * $Id: mvme160.c 2222 2007-12-04 11:46:42Z roy029 $
 *
 * mvme160.c -- module driver for the Mororola MVME160 series MPU boards
 *
 * This supports the MVME162, MVME167 and probably the MVME166 68040 MPU
 * boards. It provides VMEbus access, and on the MVME162, two or four IP
 * slots.
 *
 * At present only basic VME access is supported in the driver, and this
 * is presently something of a hack. There are no module options.
 */
#include "../internal.h"


HIDDEN IIO_STATUS iio_mvme160_vme(
    IIO_MSTATE *state, IIO_MREG *reg, IIO_OPNODE *opnode,
    IIO_OP op, unsigned first, unsigned number
) {
    /*
     * Address resolutions provided by the VMEchip2.
     * Since we know we are on a 68k, we know addresses are 32 bits.
     * THIS IS A HACK UNTIL I FINISH THE PROPER VMECHIP2 DRIVER
     */
    uint32_t addr = (uint32_t)iio_data_get_addr(opnode, first);
    /* IIO_SIZE size = (IIO_SIZE)(op & IIO_SIZE_MASK); */

    switch (op & IIO_SPACE_MASK) {
    case iio_space_io:
    case iio_space_mem16:
	/* the fixed A16/D16 mapping */
	if (addr > 0xffff)
	    return iio_error("Address out of A16 range");
	addr += 0xffff0000;
	break;

    case iio_space_mem:
    case iio_space_mem24:
	/* the fixed A24/D16 mapping */
	if (addr > 0xffffff)
	    return iio_error("Address out of A24 range");
	addr += 0xf0000000;
	break;

    case iio_space_mem32:
	return iio_fatal("VMEchip2 driver is not finished");

    default:
	return iio_error("Operation code not supported by channel");
    }

    /* write back result */
    iio_eret( iio_data_set_addr(opnode, first, (void *)addr) );
    return iio_status_ok;
}


HIDDEN IIO_STATUS iio_mvme160_init(IIO_MREG *reg, IIO_MSTATE *state) {
    /*
     * The driver needs no initialisation (yet)
     */

    return iio_status_ok;
}


IIO_STATUS iio_mvme160_install(IIO_MODULE *module, char *argv[]) {
    /*
     * The Mororola MV160 provides, in addition to the MPU, a VMEbus
     * interface (VMEchip2), timers and counters (SCC2 chip), plus
     * serial ports, ethernet, SCSI and so on. IIO is only really
     * interested in the VME and SCC things.
     */

    /* the VME bus: width is not important */
    iio_eret(
	iio_chnode(
	    module,
	    iio_chtype_vme, 0, 1,
	    iio_mvme160_vme, NULL
	)
    );
    return iio_status_ok;
}


IIO_STATUS iio_mvme160(void) {
    /*
     * At the moment the one module handles the two main variants of the 
     * MVME162 (the 162 and the 162LX) plus the MV167. Both feature the
     * same VME interface, but the 162's have IP slots
     */
    iio_eret(
	iio_minfo(
	    "mvme162",			/* Our module ID */
	    "Motorola MVME162 MPU",	/* Our name */
	    "$Revision: 2222 $",		/* File RCS ID */
	    iio_multi_no,		/* we can be multiply installed */
	    iio_mvme160_install,	/* the install function */
	    iio_mvme160_init		/* the init function */
	)
    );
    iio_eret(
	iio_minfo(
	    "mvme162lx",		/* Our module ID */
	    "Motorola MVME162LX MPU",	/* Our name */
	    "$Revision: 2222 $",		/* File RCS ID */
	    iio_multi_no,		/* we can be multiply installed */
	    iio_mvme160_install,	/* the install function */
	    iio_mvme160_init		/* the init function */
	)
    );
    iio_eret(
	iio_minfo(
	    "mvme167",			/* Our module ID */
	    "Motorola MVME167 MPU",	/* Our name */
	    "$Revision: 2222 $",		/* File RCS ID */
	    iio_multi_no,		/* we can be multiply installed */
	    iio_mvme160_install,	/* the install function */
	    iio_mvme160_init		/* the init function */
	)
    );
    return iio_status_ok;
}
