/*
 * This file is part of IIO, the Industrial IO Library
 * CSIRO Manufacturing Science and Technology
 * $Id: mbusddo3705.c 2222 2007-12-04 11:46:42Z roy029 $
 *
 * mbusddo3705.c - advansys ddo3705 digital output module
 *
 *	-host <addr>			IP address of the module
 *
 *  This board provides 16 digital outputs
 *
 *
 */

#include <stdio.h>

#include "../internal.h"

#define OUTPUT_START_ADDRESS 40000

    /* register pointer structure */
struct IIO_MREG {
    char *hostname;     /* internet address of the module */
    int sockfd;
	int reg_address; 
    IIO_MODBUS_ADVANSYSINFO info;
};

struct IIO_MSTATE {
	short outval[1];
};

HIDDEN IIO_STATUS iio_mbusddo3705_do(
    IIO_MSTATE *state, IIO_MREG *reg, IIO_OPNODE *opnode,
    IIO_OP op, unsigned first, unsigned number
	) {
	unsigned seqno;

	for (seqno = first; seqno < first + number; ++seqno) {
		switch (op) {
			case iio_op_write:
				state->outval[seqno] = (uint16_t)iio_data_get(opnode, seqno);
				break;
			case iio_op_readback:
				iio_eret( iio_data_set(opnode, seqno, state->outval[seqno]) );
				break;
			case iio_op_read:
				return iio_error("Operation code not supported by channel");
				break;
			default:
				return iio_error("Operation code not supported by channel");
		}
	}
	iio_eret ( iio_modbus_write (reg->sockfd, 0, reg->reg_address, 1, state->outval));
	return iio_status_ok;
}



HIDDEN IIO_STATUS iio_mbusddo3705_init(IIO_MREG *reg, IIO_MSTATE *state) {
    int i;
    for (i=0; i<17; i++) {
		state->outval[i] = 0;
    }
	/* other ones seemed to have to write a config word to the address but i
	 * don't think we need to for the nip */
    //state->outval[0] = reg->configWord;
    //iio_eret ( iio_modbus_write (reg->sockfd, 0, 0, 5, state->outval));
	
    iio_eret ( iio_modbus_advansys_open (reg->hostname, &reg->sockfd,
					 &reg->info));
    return (iio_status_ok);
}


HIDDEN IIO_STATUS iio_mbusddo3705_install(IIO_MODULE *module, char *argv[]) {
    /*
     * Decode the module driver arguments, resolve the ISA base address to
     * logical addresses, build the register structure containing pointers 
     * to the device, and register the channels it provides
     */
    IIO_MREG *reg;

    /* get a register structure */
    iio_eret( iio_module_reg(module, sizeof(IIO_MREG), &reg) );

    /* get a state structure */
    iio_eret( iio_module_state(module, sizeof(IIO_MSTATE)) );

    /* decode the arguments */
    /* get the mandatory internet address */
    reg->hostname = NULL;
    iio_eret( iio_arg(argv, "address", iio_arg_string, &reg->hostname) );
    if (reg->hostname == NULL)
	return iio_error("No inetrnet address specified");
	
	reg->reg_address = OUTPUT_START_ADDRESS;
	iio_eret( iio_arg(argv, "reg_address", iio_arg_int32, &reg->reg_address) );
	// printf("reg_address = %d", reg->reg_address);
	reg->reg_address = reg->reg_address; 
	
    /* register IP channels with the channel list */
    iio_eret(
	iio_chnode(
	    module,
	    iio_chtype_do, 16, 1,
	    iio_mbusddo3705_do, NULL
	)
    );
    return iio_status_ok;
}


IIO_STATUS iio_mbusddo3705(void) {
    /*
     * Call iio_minfo to register this module with IIO
     */
    iio_eret(
	iio_minfo(
	    "DDO3705",
	    "Advansys DDO3705 16 digital outputs",
	    "$Revision: 2222 $",
	    iio_multi_yes,
	    iio_mbusddo3705_install,
	    iio_mbusddo3705_init
	)
    );
    return iio_status_ok;
}
