/*
 * This file is part of IIO, the Industrial IO Library
 * CSIRO Division of Manufacturing Technology
 * $Id: done.c 408 2007-09-18 00:18:00Z ale077 $
 *
 * done.c -- IIO cleanup
 * Robin Kirkham, July 1996
 */
#include "internal.h"
#include <stdio.h>

IIO_STATUS iio_done(void) {
    /*
     * Called when the user has finished with IIO, or at least this
     * process's invocation thereof. Simply calls the OS-specific done
     * function, which in turn calls iio_done_iio() before/after the 
     * OS-specific cleanup
     */
    if (! iio_state)
	return iio_error("Library not initialised");

    iio_eret( iio_osdone() );
    return iio_status_ok;
}


IIO_STATUS iio_done_iio(void) {
    /*
     * Called by the OS-specific done-function
     */

    /* more things should go here! */
    iio_eret( iio_map_done() );

    /* this should be later, but might be OS-dependent */
    if (iio_state->log)
	iio_log("iio: done\n");

    return iio_status_ok;
}
