/*
 * This file is part of IIO, the Industrial IO Library
 * CSIRO Division of Manufacturing Technology
 * $Id: config.c 365 2003-05-12 02:31:19Z sik057 $
 *
 * config.c -- configuration file handling
 * Robin Kirkham, June 1996
 */
#include "internal.h"


IIO_STATUS iio_config_exec(char *argv[]) {
    /*
     * Interprets the tokenized line passes from iio_tfile(), and calls
     * the appropriate IIO functions to bring them to effect. argv[0] is
     * a pointer to a "source" string that should be prepended to error
     * messages. argv[1] is the "command" (first token on line)
     */

    /* test for the module install function */
    if (iio_string_cmp(argv[1], "module") == 0) {

	/* blank out the interpreted argument */
	argv[1] = iio_arg_blank;

	/* call the module install function */
	iio_eret( iio_module(argv) );
	return iio_status_ok;
    }

    /* test for the alias command */
    if (iio_string_cmp(argv[1], "alias") == 0) {

	/* blank out the interpreted argument */
	argv[1] = iio_arg_blank;

	/* call the module install function */
	iio_eret( iio_alias(argv) );
	return iio_status_ok;
    }

    /* test for the channel command */
    if (iio_string_cmp(argv[1], "channel") == 0) {

	/* blank out the interpreted argument */
	argv[1] = iio_arg_blank;

	/* call the module install function */
	iio_eret( iio_channel(argv) );
	return iio_status_ok;
    }

    /* no match */
    /* no match */
    iio_log(
	"%s: Bad command `%s'\n",
	argv[0], argv[1]
    );
    return iio_error("Bad command in configuration file");
}
