/*
 * This file is part of IIO, the Industrial IO Library
 * CSIRO Division of Manufacturing Technology
 * $Id: mc68230.h 2222 2007-12-04 11:46:42Z roy029 $
 *
 * mc68230.h -- header for Motorola MC68230 PI/T
 * Robin Kirkham, October 1996, from PIRAT original
 */

typedef struct {
    /* pointers to MC68230 registers */
    volatile uint8_t
	*pgcr, *psr, *psrr, *pivr,		/* general registers */
	*pacr, *paddr, *padr, *paar,		/* port A registers */
	*pbcr, *pbddr, *pbdr, *pbar,		/* port B registers */
	*pcdr, *pcddr,				/* port C registers */
	*tcr, *tsr, *tivr,			/* timer registers */
	*cprh, *cprm, *cprl, *crh, *crm, *crl;	/* counter registers */

} IIO_MC68230;

    /*
     * Byte offsets of registers from first, given byte packing
     *
     * If you use the pointers in a correctly set-up MC68230 
     * structure, you don't really need these
     */
#define IIO_MC68230_PGCR		0x00	/* port genl cntrl reg */
#define IIO_MC68230_PSRR		0x01	/* port service req reg */
#define IIO_MC68230_PADDR		0x02	/* port A data dir reg */
#define IIO_MC68230_PBDDR		0x03	/* port B data dir reg */
#define IIO_MC68230_PCDDR		0x04	/* port C data dir reg */
#define IIO_MC68230_PIVR		0x05	/* port int vector reg */
#define IIO_MC68230_PACR		0x06	/* port A control reg */
#define IIO_MC68230_PBCR		0x07	/* port B control reg */
#define IIO_MC68230_PADR		0x08	/* port A data reg */
#define IIO_MC68230_PBDR		0x09	/* port B data reg */
#define IIO_MC68230_PAAR		0x0a	/* port A alternate reg */
#define IIO_MC68230_PBAR		0x0b	/* port B alternate reg */
#define IIO_MC68230_PCDR		0x0c	/* port C data reg */
#define IIO_MC68230_PSR			0x0d	/* port status reg */
#define IIO_MC68230_TCR			0x10	/* timer control reg */
#define IIO_MC68230_TIVR		0x11	/* timer int vec reg */
#define IIO_MC68230_CPRH		0x13	/* ctr preload reg high */
#define IIO_MC68230_CPRM		0x14	/* ctr preload reg med */
#define IIO_MC68230_CPRL		0x15	/* ctr preload reg low */
#define IIO_MC68230_CRH			0x17	/* count reg high */
#define IIO_MC68230_CRM			0x18	/* count reg medium */
#define IIO_MC68230_CRL			0x19	/* count reg low */
#define IIO_MC68230_TSR			0x1a	/* timer status reg */


    /* PGCR port general control register */
#define	IIO_MC68230_PGCR_PMC_mask	0xc0	/* port mode mask */
#define	IIO_MC68230_PGCR_PMC_roll	6	/* port mode roll bit */
#define	IIO_MC68230_PGCR_H34_ENABLE	0x20
#define	IIO_MC68230_PGCR_H12_ENABLE	0x10
#define	IIO_MC68230_PGCR_H4_SENSE	0x08
#define	IIO_MC68230_PGCR_H3_SENSE	0x04
#define	IIO_MC68230_PGCR_H2_SENSE	0x02
#define	IIO_MC68230_PGCR_H1_SENSE	0x01

    /* PSRR port service request register */
#define	IIO_MC68230_PSRR_SVCRQS_mask	0x60	/* SVCRQ select mask */
#define	IIO_MC68230_PSRR_SVCRQS_roll	5	/* SVCRQ select roll bit */
#define	IIO_MC68230_PSRR_IPFS_mask	0x18	/* IPF select mask */
#define	IIO_MC68230_PSRR_IPFS_roll	3	/* IPF select roll bit */
#define	IIO_MC68230_PSRR_PIPC_mask	0x07	/* port int pri mask */
#define	IIO_MC68230_PSRR_PIPC_roll	0	/* port int pri roll bit */

    /* PIVR port interrupt vector register */
#define	IIO_MC68230_PIVR_IVN_mask	0xfc	/* port interrupt vector mask */
#define	IIO_MC68230_PIVR_IVN_roll	2	/* port interrupt vector roll */

    /* PACR port A control register */
#define	IIO_MC68230_PACR_SUBMODE_mask	0xc0	/* port A submode mask */
#define	IIO_MC68230_PACR_SUBMODE_roll	6	/* port A submode roll bit */
#define	IIO_MC68230_PACR_H2_CTL_mask	0x38	/* H2 control mask */
#define	IIO_MC68230_PACR_H2_CTL_roll	3	/* H2 control roll bit */
#define	IIO_MC68230_PACR_H2_INT_ENABLE	0x04	/* H2 interrupt enable */
#define	IIO_MC68230_PACR_H1_SVCRQ_ENABLE  0x02	/* H2 SVCRQ enable */
#define	IIO_MC68230_PACR_H1_STAT_CONTROL  0x01	/* H3 status control*/

    /* PBCR port B control register */
#define	IIO_MC68230_PBCR_SUBMODE_mask	0xc0	/* port B submode mask */
#define	IIO_MC68230_PBCR_SUBMODE_roll	6	/* port B submode roll bit */
#define	IIO_MC68230_PBCR_H4_CTL_mask	0x38	/* H4 control mask */
#define	IIO_MC68230_PBCR_H4_CTL_roll	3	/* H4 control roll bit */
#define	IIO_MC68230_PBCR_H4_INT_ENABLE	0x04	/* H4 interrupt enable */
#define	IIO_MC68230_PBCR_H3_SVCRQ_ENABLE  0x02	/* H3 SVCRQ enable */
#define	IIO_MC68230_PBCR_H3_STAT_CONTROL  0x01	/* H3 status control*/

    /* PSR port status register */
#define	IIO_MC68230_PSR_H4_LEVEL	0x80	/* H4 level */
#define	IIO_MC68230_PSR_H3_LEVEL	0x40	/* H3 level */
#define	IIO_MC68230_PSR_H2_LEVEL	0x20	/* H2 level */
#define	IIO_MC68230_PSR_H1_LEVEL	0x10	/* H1 level */
#define	IIO_MC68230_PSR_H4S		0x08	/* H4 status */
#define	IIO_MC68230_PSR_H3S		0x04	/* H3 status */
#define	IIO_MC68230_PSR_H2S		0x02	/* H2 status */
#define	IIO_MC68230_PSR_H1S		0x01	/* H1 status */

    /* TCR timer control register */
#define	IIO_MC68230_TCR_TCTL_mask	0xe0	/* timer control mask */
#define	IIO_MC68230_TCR_TCTL_roll	5	/* timer control roll bit */
#define	IIO_MC68230_TCR_ZD_CONTROL	0x10	/* zero detect control */
#define	IIO_MC68230_TCR_CCTL_mask	0x06	/* clock control mask */
#define	IIO_MC68230_TCR_CCTL_roll	2	/* clock control roll bit */
#define	IIO_MC68230_TCR_TIMER_ENABLE	0x01	/* timer enable */

    /* TSR timer status register */
#define	IIO_MC68230_TSR_ZD_STATUS 	0x01	/* zero detect status */

    /* some functions */
extern IIO_STATUS
    iio_mc68230_install(
	IIO_MC68230 *dd,
	IIO channel, IIO_OP space, unsigned base, unsigned stretch
    ),
    iio_mc68230_init(IIO_MC68230 *dd),
    iio_mc68230_show(IIO_MC68230 *dd);

