/*
 * This file is part of IIO, the Industrial IO Library
 * CSIRO Division of Manufacturing Technology
 * $Id: ds1620.h 365 2003-05-12 02:31:19Z sik057 $
 *
 * ds1620.h -- driver for the DALLAS IIO_DS1620 Digital Thermometer/Thermostat
 */

    /* commands to the chip */
#define IIO_DS1620_CONV_START		0xee	/* start conversion */
#define IIO_DS1620_CONV_STOP		0x22	/* stop conversion */
#define IIO_DS1620_TEMP_READ		0xaa	/* read last temperature */
#define IIO_DS1620_TH_READ		0xa1	/* read high limit */
#define IIO_DS1620_TH_WRITE		0x01	/* write high limit */
#define IIO_DS1620_TL_READ		0xa2	/* read low limit */
#define IIO_DS1620_TL_WRITE		0x02	/* write low limit */
#define IIO_DS1620_CR_READ		0xac	/* read configuration */
#define IIO_DS1620_CR_WRITE		0x0c	/* write configuration */

    /* configuration register bits */
#define IIO_DS1620_CR_DONE		(1<<8)	/* done conversion */
#define IIO_DS1620_CR_THF		(1<<7)	/* temperature high */
#define IIO_DS1620_CR_TLF		(1<<6)	/* temperature low */
#define IIO_DS1620_CR_CPU		(1<<1)	/* CPU mode */
#define IIO_DS1620_CR_1SHOT		(1<<0)	/* single-shot mode */


    /* chip access function sub-codes */
typedef enum {
    iio_ds1620_setrst,
    iio_ds1620_clrrst,
    iio_ds1620_getbit,
    iio_ds1620_putbit
} IIO_DS1620_OP;

    /* chip access function type */
typedef IIO_STATUS (* IIO_DS1620_ACFN)(void *user, IIO_DS1620_OP op, int *data);

    /* functions in chip driver */
extern IIO_STATUS
    iio_ds1620_conv_start(IIO_DS1620_ACFN fn, void *user),
    iio_ds1620_conv_stop(IIO_DS1620_ACFN fn, void *user),
    iio_ds1620_temp_read(IIO_DS1620_ACFN fn, void *user, int *temp),
    iio_ds1620_th_read(IIO_DS1620_ACFN fn, void *user, int *temp),
    iio_ds1620_th_write(IIO_DS1620_ACFN fn, void *user, int temp),
    iio_ds1620_tl_read(IIO_DS1620_ACFN fn, void *user, int *temp),
    iio_ds1620_tl_write(IIO_DS1620_ACFN fn, void *user, int temp),
    iio_ds1620_cr_read(IIO_DS1620_ACFN fn, void *user, int *temp),
    iio_ds1620_cr_write(IIO_DS1620_ACFN fn, void *user, int cr),
    iio_ds1620_show(IIO_DS1620_ACFN fn, void *user);
