#ifndef _types_h_
#define _types_h_
/*
 * This file is part of IIO, the Industrial IO Library
 * CSIRO Division of Manufacturing Technology
 * $Id: headers-types.h 2222 2007-12-04 11:46:42Z roy029 $
 *
 * types.h -- known size integer types
 * Robin Kirkham, June 1996
 */


/*
 * I hate this file, because we are second-guessing the compiler. But I see
 * no real alternative at present: only vxWorks defines certain size integer
 * types. Hence, this nonsense. We assume gcc. The #predicate() stuff is 
 * apparently not ANSI, but the compiler only complains if we use -pedantic
 * as well (but it still works). You can test this file by compiling and
 * running debris/test.c
 */

#ifndef __GNUC__
#error This should be compiled by GCC
#endif

#if defined(m68000) || defined(m68010) || defined(m68020) || \
    defined(m68030) || defined(m68040) || defined(m68060) || \
    defined(i386) || defined(i486) || defined(i586) || \
    defined(ppc) || defined(powerpc) || \
    defined(sparc) || defined(sparclite)

    /* gcc does these all like this */
typedef char int8_t;
typedef short int int16_t;
typedef int int32_t;
typedef long long int int64_t;

typedef unsigned char uint8_t;
typedef unsigned short int uint16_t;
typedef unsigned int uint32_t;
typedef unsigned long long int uint64_t;

#else
#error Integer sizes not defined
#endif

    /* is this right? */
#define widthof(typ) (sizeof(typ) * 8)

#endif
