/*********************************************************************
 *
 * CSIRO Automation
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * www.cat.csiro.au/cmst
 *
 * Copyright (c) CSIRO Manufacturing Science & Technology
 *
 *********************************************************************/

/**
 * \file vtg.c
 * \brief a short comment
 * \author your name
 *
 * A detailed description of the stuff in the file
 *
 */

#include <stdio.h>
#include <string.h>

#include <ddx.h>

#include <rtx/error.h>

#include "gpslog.h"

#include "vtg.h"

#define INIT_VTG_NAME "vtg"



char vtg_name[256];
DDX_STORE_ITEM *VTG_storeItem;



int init_vtg( GPSlog_stat *devStat )
{
  if( (devStat->verbose & 1) )
    fprintf( stderr, "Running VTG INIT\n" );

  if( devStat->ddxOn )
    {
      /* initialise ddx for vtg messages */
      strcpy( vtg_name, INIT_VTG_NAME );

      if( DDX_STORE_REGISTER_TYPE(devStat->storeId,GPS_VEL) == -1 )
	return( rtx_error("init_vtg: ddx_store_register_type() failed") );

      if( (VTG_storeItem=ddx_store_lookup_item(devStat->storeId,vtg_name,"GPS_VEL",0)) == NULL )
	return( rtx_error("init_vtg: ddx_store_lookup_item() failed") );
    }

  return( 0 );
}



int process_vtg( GPSlog_stat *devStat, RtxNMEA *mesg )
{
  GPS_VEL vtgData;

  rtx_nmea_extract_float( mesg, 1, &vtgData.heading );

  rtx_nmea_extract_float( mesg, 7, &vtgData.speed );

  if( devStat->ddxOn )
    {
      if( ddx_store_write( VTG_storeItem, &vtgData, NULL ) == -1 )
	return( rtx_error("process_vtg: ddx_store_write() failed") );
    }

  if( devStat->interactive )
    fprintf( stderr, "VTG: heading %f speed %f\n", vtgData.heading, vtgData.speed );

  return( 0 );
}


int done_vtg( GPSlog_stat *devStat )
{
  if( devStat->ddxOn )
    {
      if( ddx_store_done_item(VTG_storeItem) == -1)
	return( rtx_error("init_vtg: ddx_store_done_item() failed") );
    }
  return (0);
}
