/*
 ********************************************************************
 *
 * sirf.h - handler for binary SIRF based communications
 *           for uBLOX GPS modules
 *
 *     CSIRO Automation
 *     Queensland Centre for Advanced Technologies
 *     PO Box 883, Kenmore, QLD 4069, Australia
 *     www.cat.csiro.au/cmst
 *
 *
 * Copyright (c) CSIRO Manufacturing Science & Technology
 *
 ********************************************************************
 */
/**
 ********************************************************************
 *
 * \file sirf.h
 * \brief Handler for binary SIRF based communications for uBLOX GPS modul
 * \author Craig Worthington
 *
 ********************************************************************
 */

#ifndef __sirf_h__
#define __sirf_h__

#include <rtx/mutex.h>
#include <rtx/serial.h>
#include <rtx/time.h>



typedef struct _sirftype
{
  RtxTime       timeStamp;        /* time mesg recieved */
  int           sirfLength;       /* SiRF message length */ 
  unsigned char sirfMesg[1024];   /* current SiRF message, limited to 1024 characters */

  RtxMutex      *sirfMesg_mutex;  /* protect gps data corruption */
} RtxSIRF;



int rtx_sirf_read( int port, RtxSIRF *mesg );
int rtx_sirf_write( int port, ... );

int rtx_sirf_extract( RtxSIRF *mesg, int fieldNo, char *value );

int write(int fd, char *buff, int count );

#endif


