/*
 ********************************************************************
 *
 * gga.h - initialise and process NMEA GGA packets
 *
 *     CSIRO Automation
 *     Queensland Centre for Advanced Technologies
 *     PO Box 883, Kenmore, QLD 4069, Australia
 *     www.cat.csiro.au/cmst
 *
 *	$Id: llk.h 1505 2003-10-22 04:50:59Z wor072 $
 *
 * Copyright (c) CSIRO Manufacturing Science & Technology
 *
 ********************************************************************
 */
/**
 ********************************************************************
 *
 * \file gpslog.h
 * \brief a short comment
 * \author your name
 *
 * A detailed description of the stuff in the file
 *
 ********************************************************************
 */

#ifndef __llk_h__
#define __llk_h__

#include <rtx/nmea.h>

DDX_STORE_TYPE (
		GPS_LLK_MESG,
		struct _gps_llk_mesg {
		  GPS_UTC_TIME time;
		  double easting;
		  double northing;
		  double altitude;
		  short noSats;
		  float GDOP;
		  short gpsFIX;
		}
		);

int init_llk( GPSlog_stat *devStat );
int process_llk( GPSlog_stat *devStat, RtxNMEA *mesg );
int done_llk( GPSlog_stat *devStat );

#endif


