/*
 ********************************************************************
 *
 * gsv.h - initialise and process NMEA GSV packets
 *
 *     CSIRO Automation
 *     Queensland Centre for Advanced Technologies
 *     PO Box 883, Kenmore, QLD 4069, Australia
 *     www.cat.csiro.au/cmst
 *
 *	$Id: gsv.h 1483 2003-05-15 23:52:42Z sik057 $
 *
 * Copyright (c) CSIRO Manufacturing Science & Technology
 *
 ********************************************************************
 */
/**
 ********************************************************************
 *
 * \file gpslog.h
 * \brief a short comment
 * \author your name
 *
 * A detailed description of the stuff in the file
 *
 ********************************************************************
 */

#ifndef __gsv_h__
#define __gsv_h__

#include <rtx/nmea.h>

DDX_STORE_TYPE (
		GPS_GSV_MESG,
		struct _gps_gsv_mesg {
		  short noSats;
		  short satID[13];
		  short satElevation[13];
		  short satAzimuth[13];
		  short satSignal[13];
		}
		);

int init_gsv( GPSlog_stat *devStat );
int process_gsv( GPSlog_stat *devStat, RtxNMEA *mesg );
int done_gsv( GPSlog_stat *devStat );

#endif


