/*
 ********************************************************************
 *
 * gpslog.h - gpslog, read and process NMEA packets
 *
 *     CSIRO Automation
 *     Queensland Centre for Advanced Technologies
 *     PO Box 883, Kenmore, QLD 4069, Australia
 *     www.cat.csiro.au/cmst
 *
 *	$Id: gpslog.h 1514 2004-05-13 04:52:28Z jmr $
 *
 * Copyright (c) CSIRO Manufacturing Science & Technology
 *
 ********************************************************************
 */
/**
 ********************************************************************
 *
 * \file gpslog.h
 * \brief a short comment
 * \author your name
 *
 * A detailed description of the stuff in the file
 *
 ********************************************************************
 */

#ifndef __gpslog_h__
#define __gpslog_h__

#include <rtx/inet.h>
#include <rtx/time.h>

/* type of GPS devices supported */
#define GPS_DEVTYPE_GENERIC 0
#define GPS_DEVTYPE_PC104   1
#define GPS_DEVTYPE_SR530   2
#define GPS_DEVTYPE_UBLOX   3
#define GPS_DEVTYPE_TRIMBLE  4
#define GPS_DEVTYPE_RTK     5

typedef struct _gpslog_mesg
{
  char *name;
  int  enable;
  int  (*initProg)();
  int  (*processProg)();
  int  (*doneProg)();
} GPSlog_mesg;


typedef struct _gpslog_stat
{
  int nmeafp;                 /* file pointer to GPS serial in */
  int dgpsfp;                 /* file pointer to DGPS serial out */
  int devType;                /* type of GPS unit being used */
  char *nmeadev;              /* name of GPS serial port */
  char *dgpsdev;              /* name of DGPS serial port */
  int nmeabaud;               /* baud rate of GPS port */
  int dgpsbaud;               /* baud rate of DGPS port */

  int ddxOn;                  /* if '1' send GPS data to store */
  int file;                   /* if '1' send GPS data to a file */
  int srpc;                   /* if '1' send GPS data to SRPC socket */
  int verbose;                /* level of debugging verbosity */
  int interactive;            /* if defined, prints decoded GPS message on stderr */
  int dgps;                   /* dgps flag, '1' send DGPS to serial port */
  int gpsStatus;              /* gps status flag, if defined prints current satellite info */
  int gpsComms;               /* gps comms flags, if defined prints any output to stderr */
  int dgpsStatus;             /* dgps stat flag, if defined print DGPS multicast messages to stderr */

  char * multiAddr;           /* IP address of DGPS multicast */
  int multiPort;              /* port of DGPS multicast */
  RtxInet *inetFd;            /* file pointer to DGPS multicast */

  DDX_STORE_ID  *storeId;     /* ID of store to send GPS data to */
  FILE *fileId;               /* pointer to file to send GPS data */
  char *fileDir;              /* directory to which files are written */
  RtxTime nmeaTime;           /* local time when last nmea packet seen */
  int resetTimeout;	      /* time in seconds until hc12 reset is tried */
} GPSlog_stat;



DDX_STORE_TYPE (
		GPS_UTC_TIME,
		struct _gps_utc_time {
		  int         hours;
		  int         mins;
		  double      secs;
		}
		);

#endif


