/*
 ********************************************************************
 *
 * gga.h - initialise and process NMEA GGA packets
 *
 *     CSIRO Automation
 *     Queensland Centre for Advanced Technologies
 *     PO Box 883, Kenmore, QLD 4069, Australia
 *     www.cat.csiro.au/cmst
 *
 *	$Id: gga.h 1488 2003-06-05 02:18:19Z wor072 $
 *
 * Copyright (c) CSIRO Manufacturing Science & Technology
 *
 ********************************************************************
 */
/**
 ********************************************************************
 *
 * \file gpslog.h
 * \brief a short comment
 * \author your name
 *
 * A detailed description of the stuff in the file
 *
 ********************************************************************
 */

#ifndef __gga_h__
#define __gga_h__

#include <rtx/nmea.h>

DDX_STORE_TYPE (
		GPS_POS,
		struct _gps_gga_mesg {
		  GPS_UTC_TIME time;
		  double latitude;
		  double longitude;
		  double easting;
		  double northing;
		  double altitude;
		  short noSats;
		  short dgpsage;
		  short dgpsref;
		  float HDOP;
		  short gpsFIX;
		}
		);

int init_gga( GPSlog_stat *devStat );
int process_gga( GPSlog_stat *devStat, RtxNMEA *mesg );
int done_gga( GPSlog_stat *devStat );

#endif


