/* ********************
 *
 *
 * % process the data to get eastings and northings from GPS data
 * % uses equations from the redfearn.xls file
 * %                                              Matthew Dunbabin
 * %                                                 23rd May 2002
 */

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* % constants */
#define a 6378137.00              /* semi-major axis */
#define f (1/298.257222)          /* flattening */
#define e_sqr (2.0*f - pow(f,2))
#define False_east 500000.0       /* false easting (m) */
#define False_north 10000000.0    /* false northing (m) */
#define Ko 0.9996                 /* central scale factor */
#define Central_Merid 153.0       /* central meridian (deg) (ZONE 56) */
#define pi M_PI
#define	MaxTimeData	10000


int 	convert_to_eastnorth( double latitude, double longitude, double *easting, double *northing );
int	getdlineGPSData(char *fnameparms);


double	*tData;
double	*xData;
double	*yData;




int convert_to_eastnorth( double latitude, double longitude, double *easting, double *northing )
{
  double rho, v, psi;
  double lat_rad, long_rad;
  double E1, E2, LongCent, w1, tlat;
  double East1, East2, East3, East4, SumKo_East;
  double North1, North2, North3, North4, SumKo_North;
  double A0, A2, A4, A6;
  double Meridian_dist1, Meridian_dist2, Meridian_dist3, Meridian_dist4, Meridian_dist;

  double Easting, Northing;

  rho = a *(1 - e_sqr) / sqrt((pow((1 - e_sqr * pow(sin(latitude * pi / 180.0),2)),3)));
  v = a / sqrt(1.0 - e_sqr * pow(sin(latitude * pi / 180.0),2));
  psi = v / rho;

  lat_rad = latitude * pi / 180.0;
  long_rad = longitude * pi / 180.0;


  /* % common variables */
  E1 = cos(lat_rad);
  E2 = sin(lat_rad);
  LongCent = long_rad - Central_Merid * pi / 180.0;
  w1 = LongCent;
  tlat = tan(lat_rad);

  /* % calculated easting */
  East1 = v * E1 * w1;
  East2 = v * (pow(w1,3)) * (pow(E1,3)) * (psi - pow(tlat,2)) / 6.0;
  East3 = v * (pow(w1,5)) * (pow(E1,5)) * (4.0 * pow(psi,3) * (1.0 - 6.0*pow(tlat,2)) + pow(psi,2) * (1.0+8.0*pow(tlat,2)) - pow(psi,2) * (2.0*pow(tlat,2)) + pow(tlat,4)) / 120.0;
  East4 = v * (pow(w1,7)) * (pow(E1,7)) * (61.0 - 479.0*pow(tlat,2) + 179.0*pow(tlat,4) - pow(tlat,6)) / 5040.0;
  SumKo_East = (East1 + East2 + East3 + East4) * Ko;

  Easting = False_east + SumKo_East;


  /* % calcualte northing */
  A0 = 1.0 - e_sqr / 4.0 - (3.0 * pow(e_sqr,2) / 64.0) - (5.0 * pow(e_sqr,3) / 256.0);
  A2 = 3.0/8.0 * (e_sqr + pow(e_sqr,2) / 4.0 + 15.0 * pow(e_sqr,3) / 128.0);
  A4 = 15.0/256.0 * (pow(e_sqr,2) + 3.0/4.0*pow(e_sqr,3));
  A6 = 35.0/3072.0 * pow(e_sqr,3);

  Meridian_dist1 = a * A0 * lat_rad;
  Meridian_dist2 = -a * A2 * sin(2.0*lat_rad);
  Meridian_dist3 = a * A4 * sin(4.0*lat_rad);
  Meridian_dist4 = -a * A6 * sin(6.0*lat_rad);
  Meridian_dist = (Meridian_dist1 + Meridian_dist2 + Meridian_dist3 + Meridian_dist4);

  North1 = v * E2 * (pow(w1,2)) * E1 / 2.0;
  North2 = v * E2 * (pow(w1,4)) * (pow(E1,3)) * (4.0*pow(psi,2) + psi - pow(tlat,2)) / 24.0;
  North3 = v * E2 * (pow(w1,6)) * (pow(E1,5)) * (8.0*pow(psi,4) * (11.0-24.0*pow(tlat,2)) - 28.0*pow(psi,3) * (1-6.0*pow(tlat,2)) + pow(psi,2) * (1.0-32.0*pow(tlat,2)) - psi * (2.0*pow(tlat,2)) + pow(tlat,4)) / 720.0;
  North4 = v * E2 * (pow(w1,8)) * (pow(E1,7)) * (1385.0-3111.0*pow(tlat,2) + 543.0*pow(tlat,4) - pow(tlat,6)) / 40320.0;
  SumKo_North = (North1 + North2 + North3 + North4 + Meridian_dist) * Ko;

  Northing = False_north + SumKo_North;

  /* return calc values */
  *(northing) = Northing;
  *(easting) = Easting;
  
  return 0;
}
