#include <assert.h>
#include <stdlib.h>
#include <rtx/error.h>
#include <rtx/message.h>
#include <ddxvideo1394/camera.h>
#include <ddxvideo1394/srpc.h>
#include <ddxvideo1394/features.h>

static DDX_VIDEO1394_CAMERA * camera_array = NULL;
static unsigned int camera_array_size = 0;

static int
set_feature_srpc (char *string, int len, int argc, char *argv[])
{
	int i,camera_number = -1;
	if (camera_array == NULL) return 1;
	if (argc >= 3) 
		sscanf(argv[2]," %d ", &camera_number);
	if (camera_number == -1) {
		// Third argument was not a number, so we assume we 
		// are only talking to the first camera
		camera_number = 0;
	} else {
		// Third argument was camera bus number
		// look for a camera with this bus number
		camera_number = 0;
		for (i=0;i<camera_array_size;i++) {
			if (camera_number == camera_array[i].bus_number) {
				camera_number = i;
				break;
			}
		}
		if (i == camera_array_size) {
			rtx_error_flush("SRPC: set feature: invalid camera bus number");
		}
	}
	return set_feature(&camera_array[camera_number],string,len,argc,argv);
}



static int
wbalance_srpc (char *string, int len, int argc, char *argv[])
{
	int i,camera_number = -1;
	if (camera_array == NULL) return 1;
	switch (argc) {
		case 1 : 
			// no argument: assuming auto for the first camera
			camera_number = 0;
			break;
		case 2 :
			// 1 argument: can only be the bus number 
			sscanf(argv[1]," %d ", &camera_number);
			// hiding the bus number for the set_white balance function
			argc -= 1;
			break;
		case 3 : 
			// 2 argument: assuming white balance for first camera
			camera_number = 0;
			break;
		case 4 :
			// 3 argument: white balance params + bus number
			sscanf(argv[3]," %d ", &camera_number);
			// hiding the bus number for the set_white balance function
			argc -= 1;
			break;
		default :
			break;
	}

	// Third argument was camera bus number
	// look for a camera with this bus number
	for (i=0;i<camera_array_size;i++) {
		if (camera_number == camera_array[i].bus_number) {
			camera_number = i;
			break;
		}
	}
	if (i == camera_array_size) {
		// failed to find this camera, reverting to first one
		camera_number = 0;
		rtx_error_flush("SRPC: set white balance: invalid camera bus number");
	}
	return set_white_balance(&camera_array[camera_number],string,len,argc,argv);
}


int init_srpc_server(RtxSrpc ** srpcServerHandle, 
		DDX_VIDEO1394_CONFIG * config,
		DDX_VIDEO1394_CAMERA * cameras, unsigned int num_cameras)
{
	assert(srpcServerHandle != NULL);

	camera_array = cameras;
	camera_array_size = num_cameras;

	// Setup SRPC server

	rtx_message ("Creating srpc server on %d", config->program);
	if ((*srpcServerHandle = rtx_srpc_init (config->program)) == NULL)
	{
		rtx_error_flush ("rtx_srpc_init: failed");
		exit (1);
		return 1;
	}
	rtx_srpc_register (*srpcServerHandle, "brightness", set_feature_srpc);
	rtx_srpc_register (*srpcServerHandle, "exposure", set_feature_srpc);
	rtx_srpc_register (*srpcServerHandle, "saturation", set_feature_srpc);
	rtx_srpc_register (*srpcServerHandle, "sharpness", set_feature_srpc);
	rtx_srpc_register (*srpcServerHandle, "wbalance", wbalance_srpc);

	return 0;
	
}

int terminate_srpc_server(RtxSrpc * srpcServerHandle)
{
	rtx_srpc_done(srpcServerHandle);
	camera_array = NULL;
	camera_array_size = 0;
	return 0;
}

