
/*
 * Copyright (C) 2000-2004 Damien Douxchamps  <ddouxchamps@users.sf.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include <dc1394/control.h>

const char     *feature_name_list[DC1394_FEATURE_NUM] = {
	"Brightness",
	"Exposure",
	"Sharpness",
	"White Balance",
	"Hue",
	"Saturation",
	"Gamma",
	"Shutter",
	"Gain",
	"Iris",
	"Focus",
	"Temperature",
	"Trigger",
	"Trigger Delay",
	"White Shading",
	"Frame Rate",
	"Zoom",
	"Pan",
	"Tilt",
	"Optical Filter",
	"Capture Size",
	"Capture Quality"
};

const char     *video_mode_to_str(dc1394video_mode_t mode)
{
	switch (mode) {
		case DC1394_VIDEO_MODE_160x120_YUV444:
			return "160x120 YUV444";
		case DC1394_VIDEO_MODE_320x240_YUV422:
			return "320x240 YUV422";
		case DC1394_VIDEO_MODE_640x480_YUV411:
			return "640x480 YUV411";
		case DC1394_VIDEO_MODE_640x480_YUV422:
			return "640x480 YUV422";
		case DC1394_VIDEO_MODE_640x480_RGB8:
			return "640x480 RGB8";
		case DC1394_VIDEO_MODE_640x480_MONO8:
			return "640x480 MONO8";
		case DC1394_VIDEO_MODE_640x480_MONO16:
			return "640x480 MONO16";
		case DC1394_VIDEO_MODE_800x600_YUV422:
			return "800x600 YUV422";
		case DC1394_VIDEO_MODE_800x600_RGB8:
			return "800x600 RGB8";
		case DC1394_VIDEO_MODE_800x600_MONO8:
			return "800x600 MONO8";
		case DC1394_VIDEO_MODE_1024x768_YUV422:
			return "1024x768 YUV422";
		case DC1394_VIDEO_MODE_1024x768_RGB8:
			return "1024x768 RGB8";
		case DC1394_VIDEO_MODE_1024x768_MONO8:
			return "1024x768 MONO8";
		case DC1394_VIDEO_MODE_800x600_MONO16:
			return "800x600 MONO16";
		case DC1394_VIDEO_MODE_1024x768_MONO16:
			return "1024x768 MONO16";
		case DC1394_VIDEO_MODE_1280x960_YUV422:
			return "1280x960 YUV422";
		case DC1394_VIDEO_MODE_1280x960_RGB8:
			return "1280x960 RGB8";
		case DC1394_VIDEO_MODE_1280x960_MONO8:
			return "1280x960 MONO8";
		case DC1394_VIDEO_MODE_1600x1200_YUV422:
			return "1600x1200 YUV422";
		case DC1394_VIDEO_MODE_1600x1200_RGB8:
			return "1600x1200 RGB8";
		case DC1394_VIDEO_MODE_1600x1200_MONO8:
			return "1600x1200 MONO8";
		case DC1394_VIDEO_MODE_1280x960_MONO16:
			return "1280x960 MONO16";
		case DC1394_VIDEO_MODE_1600x1200_MONO16:
			return "1600x1200 MONO16";
		case DC1394_VIDEO_MODE_EXIF:
			return "EXIF";
		case DC1394_VIDEO_MODE_FORMAT7_0:
			return "FORMAT7 0";
		case DC1394_VIDEO_MODE_FORMAT7_1:
			return "FORMAT7 1";
		case DC1394_VIDEO_MODE_FORMAT7_2:
			return "FORMAT7 2";
		case DC1394_VIDEO_MODE_FORMAT7_3:
			return "FORMAT7 3";
		case DC1394_VIDEO_MODE_FORMAT7_4:
			return "FORMAT7 4";
		case DC1394_VIDEO_MODE_FORMAT7_5:
			return "FORMAT7 5";
		case DC1394_VIDEO_MODE_FORMAT7_6:
			return "FORMAT7 6";
		case DC1394_VIDEO_MODE_FORMAT7_7:
			return "FORMAT7 7";
		default:
			return "Invalide video mode";
	}
	return NULL;
}

const char     *frame_rate_to_str(dc1394framerate_t rate)
{
	switch (rate) {
		case DC1394_FRAMERATE_1_875:
			return "1.875";
		case DC1394_FRAMERATE_3_75:
			return "3.75";
		case DC1394_FRAMERATE_7_5:
			return "7.5";
		case DC1394_FRAMERATE_15:
			return "15";
		case DC1394_FRAMERATE_30:
			return "30";
		case DC1394_FRAMERATE_60:
			return "60";
		case DC1394_FRAMERATE_120:
			return "120";
		case DC1394_FRAMERATE_240:
			return "240";
		default:
			return "Invalid frame rate";
	}
	return NULL;
}


