#ifndef DDXVIDEO1394_PARAMS_H
#define DDXVIDEO1394_PARAMS_H
#ifdef  __cplusplus
extern          "C"
{
#endif

#include <ddxvideo1394/ddxvideo.h>
#include <ddxvideo1394/camera.h>

/**
 * Just a switch statement to pick out only those features which are in the ddx
 * camera feature structure (which may be different to the full camera features)
 */
extern int
features_2_ddx_params (DDX_VIDEO1394_CAMERA * camera,	/*!< The camera object */
		DDX_VIDEO_1394_PARAMS * paramState	/*!< The camera feature set for the store */
		);


/**
 * Checks for a change in the structure
 * \returns 0 for no change, else 1
 */
extern int
check_new_params (
		DDX_VIDEO1394_CAMERA * camera,	/*!< The camera object */
		DDX_VIDEO_1394_PARAMS * paramState,	/*!< Present state */
		DDX_VIDEO_1394_PARAMS * paramStatePrev	/*!< State at previous iteration */
		);

/**
 * Basically selects which features are available and only allows operations on
 * those features, only if they have been modified...
 * This function is for DDX store changing of features
 */
extern int
check_and_set_parameters_from_ddx (
		DDX_VIDEO1394_CAMERA * camera,
		DDX_VIDEO_1394_PARAMS * parPrev,	/*!< The store last demand parameters */
		DDX_VIDEO_1394_PARAMS * par,			/*!< The store demand parameters */
		int verbose
		);

#ifdef  __cplusplus
}
#endif
#endif // DDXVIDEO1394_PARAMS_H
