#ifndef DDXVIDEO1394_FEATURES_H
#define DDXVIDEO1394_FEATURES_H
#ifdef  __cplusplus
extern          "C"
{
#endif

#include <ddxvideo1394/config.h>
#include <ddxvideo1394/camera.h>

/**
 * Convert a camera feature enum into a string 
 * debugging/display purpose
 */
extern const char * string_of_feature (int feature);
extern int  feature_of_string (const char * feature);

/**
 * Return the value of the config variable 
 * associated with a camera feature enum
 */
extern int auto_option(const DDX_VIDEO1394_CONFIG * prm, int feature);

extern int set_feature(DDX_VIDEO1394_CAMERA * camera, 
		char *string, int len, int argc, char *argv[]);

extern int set_white_balance (DDX_VIDEO1394_CAMERA * camera, 
		char *string, int len, int argc, char *argv[]);

/**
 * Use all auto_* variables to set required 
 * camera feature to auto, if supported
 */

extern void set_camera_features_auto (DDX_VIDEO1394_CAMERA * camera,
		DDX_VIDEO1394_CONFIG * prm);

#ifdef USE_MARLIN_TOOLS
/**
 * Manage MARLIN options if supported
 */
extern int manage_marlin_options (DDX_VIDEO1394_CAMERA * camera,
		DDX_VIDEO1394_CONFIG * prm);
#endif


#ifdef  __cplusplus
}
#endif
#endif // DDXVIDEO1394_FEATURES_H
