#ifndef DDXVIDEO1394_DC1394_H
#define DDXVIDEO1394_DC1394_H
#ifdef  __cplusplus
extern          "C"
{
#endif

#include <ddxvideo1394/camera.h>
#include <ddxvideo1394/config.h>

// Manage the -list option : have a look to each camera
// Get the number of ports (cards) 
extern int list_1394_cameras(DDX_VIDEO1394_CONFIG * config);

extern int create_1394_auto_name(DDX_VIDEO1394_CONFIG * config,
		DDX_VIDEO1394_CAMERA * camera);

extern int init_1394_cameras(DDX_VIDEO1394_CAMERA * camera,
		unsigned int num_cameras,
		DDX_VIDEO1394_CONFIG * config);

extern int terminate_1394_cameras(DDX_VIDEO1394_CAMERA * camera,
		unsigned int num_cameras);

extern int update_1394_feature_set(DDX_VIDEO1394_CAMERA * cameras,
		unsigned int num_cameras);

typedef int (*FrameHandler)(int camera_index, 
		unsigned char * frame_buffer,
		unsigned int frame_width, unsigned int frame_height,
		void * arg);

extern int capture_1394_cameras(DDX_VIDEO1394_CAMERA * cameras,
		unsigned int num_cameras, 
		DDX_VIDEO1394_CONFIG * config,
		FrameHandler fh, void * fharg);

#ifdef  __cplusplus
}
#endif
#endif // DDXVIDEO1394_DC1394_H
