#ifndef DDXVIDEO_CONVERTION_H
#define DDXVIDEO_CONVERTION_H
#ifdef  __cplusplus
extern          "C"
{
#endif

#include <dc1394/control.h>

/**
 * Convert a generic frame into YUV420 Planar format
 */
int frame_to_yuv420p(unsigned char *ip, dc1394color_coding_t coding, unsigned char *y,
		unsigned char *u, unsigned char *v, int w, int h); 

/**
 * Convert a bayer frame into YUV420 Planar format
 * WARNING: the frame format is assumed correct. 
 */
int bayer_frame_to_yuv420p(unsigned char *ip, dc1394color_coding_t coding, dc1394color_filter_t bayer, unsigned char *y,
		unsigned char *u, unsigned char *v, int w, int h) ;

/**
 * Convert monochrome camera capture buffers into YUV420 Planar format
 * \warning Requires a bit more thought 
 */
void mono_to_yuv420p (unsigned char *ip, unsigned char *y,
		unsigned char *u, unsigned char *v, int w, int h);

/**
 * Convert 16-bit monochrome camera capture buffers into YUV420 Planar format
 * \warning Requires a bit more thought 
 */
void mono16_to_yuv420p (unsigned char *ip, unsigned char *y,
		unsigned char *u, unsigned char *v, int w, int h);

/**
 * Convert RGB camera capture buffers into YUV420 Planar format
 * Date is packed as rgbrgb. 
 * \todo Map u and v 
 */
void rgb_to_yuv420p (unsigned char *ip, unsigned char *y,
		unsigned char *u, unsigned char *v, int w, int h);

/**
 * Convert YUV444 camera capture buffers into YUV420 Planar format
 * Date is packed as u0 y0 v0 u1 y1 v1 (24bits per pixel) 
 */
void yuv444_to_yuv420p (unsigned char *ip, unsigned char *y,
		unsigned char *u, unsigned char *v, int w, int h);


/**
 * Convert YUV422 camera capture buffers into YUV420 Planar format
 * Data is packed as u0 y0 v0 y1 u2 y2 v2 y3 (16bits per pixel)
 * Ignore colour information from every second line 
 */
void yuv422_to_yuv420p (unsigned char *ip, unsigned char *y,
		unsigned char *u, unsigned char *v, int w, int h);

/**
 * Convert YUV411 camera capture buffers into YUV420 Planar format
 * Data is packed as u0 y0 y1 v0 y2 y3 u4 y4 y5 v4 y6 y7 (12bits/pixel)
 * \warning In this mode - oversample in Horiz and subsample in Vert
 */
void yuv411_to_yuv420p (unsigned char *ip, unsigned char *y,
		unsigned char *u, unsigned char *v, int w, int h);

/**
 * Convert BGGR camera capture buffers into YUV420 Planar format
 * \todo Improve Y estimation 
 */
void bggr_to_yuv420p (unsigned char *ip, unsigned char *Y,
		unsigned char *U, unsigned char *V, int w, int h);

/**
 * Convert RGGB camera capture buffers into YUV420 Planar format
 * \todo Improve Y estimation 
 */
void rggb_to_yuv420p (unsigned char *ip, unsigned char *Y,
		unsigned char *U, unsigned char *V, int w, int h);

#ifdef  __cplusplus
}
#endif
#endif // DDXVIDEO_CONVERTION_H
