#ifndef DDXVIDEO1394_CONFIG_H
#define DDXVIDEO1394_CONFIG_H
#ifdef  __cplusplus
extern          "C"
{
#endif

#include <stdio.h>
#include <dc1394/control.h>

typedef struct {
	char *device;		// Required for DMA 
	int program;		// SRPC program number
	int nostore;
	int nodma;
	int nodirect;       // Use less computing power and write directly to store
	int stdvideo;       // Use the old standard DDX_VIDEO structure
	int strongsync;     // enforce multi-camera synchronisation by copying 
						// captured image to local buffer before conversion
	int paused;         // Start the camera in paused mode

	char *name;		/*!< Name of Video in store  */
	int limit;			/*!< Run program for so many cycles (-1 is forever) */
	int list;			/*!< List cameras devices on firewire bus */
	int dots;			/*!< Display a dot for each capture */
	int port;           /*!< Index for muliple 1394 cards */

	unsigned int num_captured_cameras;
	int numbers[64];			/*!< Camera Number, at most 64 cameras on the bus */
	int verbose;		/*!< Print time stamp */



	double param_time;  /*!< delay between parameter update */

	dc1394color_coding_t coding[64];	/*!< Video coding in this mode (yuv, ...) */
	dc1394video_mode_t videomode[64];			/*!< Camera Number, at most 64 cameras on the bus */
	double dfps[64]; /*!< Camera fps as a double */
	dc1394framerate_t fps[64];			/*!< Camera frame rate */
	dc1394color_filter_t bayermode; /*!< Bayer mode, -1 for none */

	unsigned int top;	/*!< Top corner of ROI */
	unsigned int left;	/*!< Left corner of ROI */
	unsigned int width;	/*!< Width of ROI */
	unsigned int height;	/*!< Height of ROI */

	int use_marlin;
	int auto_shading;
	char * lut_table_str;
	char * shading_image_str;

	int all_features_auto;	// Try to set all possible features to auto
	int auto_brightness;	// Try to set brightness to auto
	int auto_exposure;		// Try to set exposure to auto
	int auto_sharpness;		// Try to set sharpness to auto
	int auto_white_balance;	// Try to set white_balance to auto
	int auto_hue;		// Try to set hue to auto
	int auto_saturation;	// Try to set saturation to auto
	int auto_gamma;		// Try to set gamma to auto
	int auto_shutter;		// Try to set shutter to auto
	int auto_gain;		// Try to set gain to auto
	int auto_iris;		// Try to set iris to auto
	int auto_focus;		// Try to set focus to auto
	int auto_temperature;	// Try to set temperature to auto
	int auto_trigger;		// Try to set trigger to auto
	int auto_trigger_delay;		// Try to set trigger to auto
	int auto_white_shading;		// Try to set trigger to auto
	int auto_frame_rate;		// Try to set trigger to auto
	int auto_zoom;		// Try to set zoom to auto
	int auto_pan;		// Try to set pan to auto
	int auto_tilt;		// Try to set tilt to auto
	int auto_optical_filter;	// Try to set optical_filter to auto
	int auto_capture_size;	// Try to set capture_size to auto
	int auto_capture_quality;	// Try to set capture_quality to auto

} DDX_VIDEO1394_CONFIG;

extern int config_init(DDX_VIDEO1394_CONFIG * config);

extern int config_print(DDX_VIDEO1394_CONFIG * config,FILE * fp);

extern int config_parse(DDX_VIDEO1394_CONFIG * config,
		const char * rcsid, int argc, const char * argv[]);

extern int config_terminate(DDX_VIDEO1394_CONFIG * config);

extern int config_set_name(DDX_VIDEO1394_CONFIG * config, 
		const char * name);

extern int config_set_device(DDX_VIDEO1394_CONFIG * config, 
		const char * device);

#ifdef  __cplusplus
}
#endif

#endif // DDXVIDEO1394_CONFIG_H
