
/** \file
Copyright (c) CSIRO
\brief   Print DDX Video frame numbers 
\author  Elliot.Duff@csiro.au
*/
static char    *rcsid =
	"$Header$";

#include <stdio.h>
#include <stdlib.h>
#include <rtx/message.h>
#include <rtx/time.h>
#include <rtx/timer.h>
#include <rtx/error.h>
#include <rtx/main.h>
#include <rtx/getopt.h>

#include <ddx.h>
#include "ddxvideo.h"

DDX_STORE_ID   *storeId = NULL;
DDX_STORE_ITEM *itemPtr = NULL;
DDX_VIDEO      *video;

char           *name = "video";
int             done = 0;
int             frames = 100;
int             verbose = 0;

void           *
write_thread(void *arg)
{
	int             i = 0;
	RtxTime         ts;

	while (!done) {
		if (ddx_store_read_direct(itemPtr, &ts, 10.0, 1) != 0)
			return rtx_error_null("Unable to read video");
		printf("%d %d %ld %ld\n",
		       i++, video->frame, ts.seconds, ts.nanoSeconds);
	}
	return NULL;
}

RtxGetopt       myOpts[] = {
	{"name", "Name of Video Stream in Store",
	 {{RTX_GETOPT_STR, &name, "name"}
	  , RTX_GETOPT_END_ARG}
	 }
	,
	{"frames", "Write Number of frames - Not used yet",
	 {{RTX_GETOPT_INT, &frames, "frames"}
	  , RTX_GETOPT_END_ARG}
	 }
	,
	RTX_GETOPT_END
};

char           *help = "CSIRO Video Server Project \nStream Raw Video ";

int
main(int ac, char *av[])
{

	RtxThread      *th = NULL;

	rtx_main_init(av[0], 0);
	if (RTX_GETOPT_CMD(myOpts, ac, av, rcsid, help) == -1) {
		RTX_GETOPT_PRINT(myOpts, av[0], rcsid, help);
		exit(-1);
	}

	if ((storeId = ddx_store_open(NULL, 0, 5)) == NULL)
		return rtx_error("Unable to open store");

	if ((itemPtr = ddx_store_lookup_item(storeId, name, NULL, 0)) == NULL)
		return rtx_error("Unable to lookup var");

	video = ddx_store_var_pointer(itemPtr);

	if ((th = rtx_thread_create("write thread", 0,
				    RTX_THREAD_SCHED_OTHER, 0, 0,
				    RTX_THREAD_CANCEL_DEFERRED,
				    write_thread, NULL, NULL, NULL)) == NULL) {
		rtx_error_flush("rtx_thread_create() failed");
		exit(-1);
	}

	if (rtx_main_wait_shutdown(90))
		rtx_error_flush("rtx_main_wait_shutdown() failed");

	done = 1;
	ddx_store_done_item(itemPtr);
	ddx_store_close(storeId);
	ddx_client_done();
	return 0;
}
