
/** \file
Copyright (c) CSIRO Robotics
\brief 		Capture video and copy to store using USB
\warning 	This has not been written yet
\todo		This program has to be written
\author		No One yet
*/

static char    *rcsid =
	"$Header$";

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>		// Needed by open()
#include <sys/ioctl.h>		// Needed by ioctl()
#include <sys/mman.h>		// Needed by PROT and MAP
#include <fcntl.h>		// Needed by O_RDWR
#include <errno.h>		// Needed by perror()
#include <string.h>		// Needed strerror()

#include <linux/types.h>	// Video 4 Linux stuff
#include <linux/videodev.h>

#include <rtx/message.h>	// Real Time Extensions
#include <rtx/time.h>
#include <rtx/error.h>
#include <rtx/thread.h>
#include <rtx/main.h>
#include <rtx/getopt.h>
#include <ddx.h>

DDX_STORE_ID   *storeId = NULL;	// Pointer to Store 
DDX_STORE_ITEM *itemPtr = NULL;	// Pointer to Store Item 

#include "ddxvideo.h"

int             done = 0;	// Flag to stop Capture Thread 
int             debug = 0;
int             width, height;
int             skip = 1;
int             limit = -1;	/*!< Run for ever */
int             deinterlace = 0;
char           *name = "video";	/*!< Name of Video in store  */

int             videoCamera = 0;	// Camera Number 
int             videoFrame = 0;
int             videoNorm;
int             videoFormat = VIDEO_PALETTE_YUV420P;
int             videoHandle;	/*!< The Video Device handler */
int             videoColour = 32768;	/*!< Colour Saturation */
int             videoContrast = 32768;	/*!< Picture Contrast */
char           *videoMemory;	/*!< Pointer to Video Memory */
char           *videoDevice = "/dev/video0";	/*!< Name of video Device */
char           *videoSize = "PAL";	/*!< String describing video Size */

struct video_capability vid_cap;
struct video_channel vid_chn;
struct video_mbuf vid_buf;
struct video_mmap vid_map;
struct video_picture vid_pic;

void           *
capture_thread(void *arg)
{
	int             i, np;
	int             count = 0;
	int             frame = 0;
	RtxTime         ts;
	void           *p;
	DDX_VIDEO      *v;
	int             w1, w2, h1, h2, h4;

	v = (DDX_VIDEO *) ddx_store_var_pointer(itemPtr);

	np = width * height;
	w1 = width;
	w2 = width / 2;
	h1 = height;
	h2 = height / 2;
	h4 = height / 4;

	// Should have 4 fields in PAL mode

	if (deinterlace) {
		v->fields = 2;
		v->width = width;
		v->height = height / 2;
	}
	else {
		v->fields = 1;
		v->width = width;
		v->height = height;
	}

	while (!done) {

		count++;
		rtx_time_get(&ts);

		// Start copying to the next frame 

		vid_map.frame = (count + 1) % vid_buf.frames;
		if (ioctl(videoHandle, VIDIOCMCAPTURE, &vid_map) == -1) {
			perror("VIDIOCMCAPTURE");
			exit(-1);
		}

		// Stop writing to the old frame 

		videoFrame = count % vid_buf.frames;
		while (((ioctl(videoHandle, VIDIOCSYNC, &videoFrame) < 0)
			&& ((errno == EAGAIN) || errno == EINTR)));

		// Skip every nth frame, if skip == 1 don''t skip.

		if (count % skip != 0)
			continue;

		// Insert the image into the store

		v->frame = frame++;

		if (deinterlace) {
			p = videoMemory + vid_buf.offsets[videoFrame];
			/*
			 * for(i=0; i<h1; i++) { memcpy(v->y+i*w1,p,w1); p += w1; }
			 * for(i=0; i<h2; i++) { memcpy(v->v+i*w2,p,w2); p += w2; }
			 * for(i=0; i<h2; i++) { memcpy(v->u+i*w2,p,w2); p += w2; }
			 */

			for (i = 0; i < h2; i++) {
				memcpy(v->y + i * w1, p, w1);
				p += w1;
				memcpy(v->y + (h2 + i) * w1, p, w1);
				p += w1;
			}
			for (i = 0; i < h4; i++) {
				memcpy(v->v + i * w2, p, w2);
				p += w2;
				memcpy(v->v + (h4 + i) * w2, p, w2);
				p += w2;
			}
			for (i = 0; i < h4; i++) {
				memcpy(v->u + i * w2, p, w2);
				p += w2;
				memcpy(v->u + (h4 + i) * w2, p, w2);
				p += w2;
			}
		}
		else {
			p = videoMemory + vid_buf.offsets[videoFrame];
			memcpy(v->y, p, np);
			p += np;	// Y in FIFO 1
			memcpy(v->v, p, np / 4);
			p += np / 4;	// Cb in FIFO 2
			memcpy(v->u, p, np / 4);	// Cr in FIFO 3
		}

		if (ddx_store_write_direct(itemPtr, NULL) == -1)
			rtx_error("ddx_store_write: %s", strerror(errno));

		if (debug)
			fprintf(stderr, "%d %ld %ld\r", frame, ts.seconds,
				ts.nanoSeconds);
		if (frame == limit)
			rtx_main_signal_shutdown();
	}

	return (NULL);
}

RtxGetopt       myOpts[] = {
	{"name", "Name of Video in Store",
	 {{RTX_GETOPT_STR, &name, "name"}
	  , RTX_GETOPT_END_ARG}
	 }
	,
	{"deinterlace", "Deinterlace image",
	 {{RTX_GETOPT_SET, &deinterlace, "deinterlace"}
	  , RTX_GETOPT_END_ARG}
	 }
	,
	{"skip", "Skip frames",
	 {{RTX_GETOPT_INT, &skip, "skip"}
	  , RTX_GETOPT_END_ARG}
	 }
	,
	{"limit", "Run until frame equals limit",
	 {{RTX_GETOPT_INT, &limit, "limit"}
	  , RTX_GETOPT_END_ARG}
	 }
	,
	{"camera", "Select video camera",
	 {{RTX_GETOPT_INT, &videoCamera, "videoCamera"}
	  , RTX_GETOPT_END_ARG}
	 }
	,
	{"colour", "Set colour saturation",
	 {{RTX_GETOPT_INT, &videoColour, "videoColour"}
	  , RTX_GETOPT_END_ARG}
	 }
	,
	{"contrast", "Set video contrast",
	 {{RTX_GETOPT_INT, &videoContrast, "videoContrast"}
	  , RTX_GETOPT_END_ARG}
	 }
	,
	{"device", "Select video device",
	 {{RTX_GETOPT_STR, &videoDevice, "videoDevice"}
	  , RTX_GETOPT_END_ARG}
	 }
	,
	{"size", "Select video size",
	 {{RTX_GETOPT_STR, &videoSize, "videoSize"}
	  , RTX_GETOPT_END_ARG}
	 }
	,
	RTX_GETOPT_END
};

char           *help =
	"CSIRO Video Server Project \nCapture video and copy to Store";

int
main(int ac, char *av[])
{
	int             i;
	RtxThread      *th = NULL;

	if (RTX_GETOPT_CMD(myOpts, ac, av, rcsid, help) == -1) {
		RTX_GETOPT_PRINT(myOpts, av[0], rcsid, help);
		exit(-1);
	}

	switch (videoSize[0]) {
	case 'P':
		width = 768;
		height = 576;
		break;
	case '4':
		width = 704;
		height = 576;
		break;
	case 'C':
		width = 352;
		height = 288;
		break;
	case 'Q':
		width = 176;
		height = 144;
		break;
	default:
		sscanf(videoSize, "%dx%d", &width, &height);
	}

	// Open Video4Linux Channel

	vid_chn.channel = 1;	/* Need to set a channel before opening device */
	if (debug)
		printf("Opening [%s] Camera [%d]\n", videoDevice, videoCamera);
	for (i = 5; i > 0; i--) {
		videoHandle = open(videoDevice, O_RDWR);
		if (videoHandle == -1)
			sleep(1);
		else
			break;
	}
	if (i == 0) {
		fprintf(stderr, "Can't open [%s]\n", videoDevice);
		exit(-1);
	}

	if (ioctl(videoHandle, VIDIOCGCAP, &vid_cap) == -1) {
		perror("VIDIOCGCAP");
		exit(-1);
	}
	if (ioctl(videoHandle, VIDIOCGCHAN, &vid_chn) == -1) {
		perror("VIDIOCGCHAN");
		exit(-1);
	}
	if (ioctl(videoHandle, VIDIOCGMBUF, &vid_buf) == -1) {
		perror("VIDIOMBUF");
		exit(-1);
	}
	if (ioctl(videoHandle, VIDIOCGPICT, &vid_pic) == -1) {
		perror("VIDIOCGPICT");
		exit(-1);
	}

	if ((videoMemory =
	     mmap(0, vid_buf.size, PROT_READ | PROT_WRITE, MAP_SHARED,
		  videoHandle, 0)) == ((void *) -1)) {
		perror("mmap()");
		exit(-1);
	}

	if (debug) {
		fprintf(stderr, "Brightness : %d\n", vid_pic.brightness);
		fprintf(stderr, "Whiteness  : %d\n", vid_pic.whiteness);
		fprintf(stderr, "Hue        : %d\n", vid_pic.hue);
		fprintf(stderr, "Colour     : %d\n", vid_pic.colour);
		fprintf(stderr, "Contrast   : %d\n", vid_pic.contrast);
		fprintf(stderr, "Depth      : %d\n", vid_pic.depth);
		fprintf(stderr, "Palette    : %d\n", vid_pic.palette);
	}

	vid_pic.colour = videoColour;
	vid_pic.contrast = videoContrast;
	vid_map.width = width;
	vid_map.height = height;
	vid_map.frame = videoFrame;
	vid_map.format = videoFormat;
	vid_chn.norm = videoNorm;
	vid_chn.channel = videoCamera;

	if (ioctl(videoHandle, VIDIOCSPICT, &vid_pic) == -1) {
		perror("VIDIOCGPICT");
		exit(-1);
	}
	if (ioctl(videoHandle, VIDIOCSCHAN, &vid_chn) == -1) {
		perror("VIDIOCSCHAN");
		exit(-1);
	}

	rtx_main_init(av[0], 0);

	if (ddx_client_init(0) == -1)
		return (rtx_error("Unable to initialize library"));

	if ((storeId = ddx_store_open(NULL, 0, 5)) == NULL)
		return (rtx_error("Unable to open store"));

	if (DDX_STORE_REGISTER_TYPE(storeId, DDX_VIDEO) == -1)
		return (rtx_error("Unable to register type"));

	if ((itemPtr =
	     ddx_store_lookup_item(storeId, name, "DDX_VIDEO", 0)) == NULL)
		return (rtx_error("Unable to lookup var"));

	if ((th = rtx_thread_create("capture thread", 0,
				    RTX_THREAD_SCHED_OTHER, 0, 0,
				    RTX_THREAD_CANCEL_DEFERRED,
				    capture_thread, NULL,
				    NULL, NULL)) == NULL) {
		rtx_error_flush("rtx_thread_create() failed");
		exit(-1);
	}

	if (rtx_main_wait_shutdown(90))
		rtx_error_flush("rtx_main_wait_shutdown() failed");

	done = 1;
	rtx_thread_destroy_sync(th);
	ddx_store_done_item(itemPtr);
	ddx_store_close(storeId);
	ddx_client_done();
	close(videoHandle);
	munmap(videoMemory, vid_buf.size);
	exit(0);
}
