
/*********************************************************************
* \brief	Video data structure for the store 
* \author 	Elliot Duff & Fabrice Chinjoie
* \warning 	The store will need at least 3M of shared memory 
* Video formats
* - Megapixel	1600x1200
* - spal 	768x576
* - pal		720x576
* - 4cif	704x576
* - cif		352x288
* 
* Each video frame is made up a number of planes (y,u,v) and fields.
* The fields are placed on top of one another in memory.
* 

  DDX_STORE_ID    * storeId = NULL;
  DDX_STORE_ITEM  * itemPtr = NULL;
  DDX_VIDEO       * video;
  char            * name = "video";

  if ((itemPtr = ddx_store_lookup_item (storeId,name,NULL,0)) == NULL)
    return rtx_error ("Unable to lookup var");

  video = ddx_store_var_pointer(itemPtr);

  if( ddx_store_read_direct(itemPtr, &ts, 10.0, 1) == -1 )
    return rtx_error("Unable to read video");

  fprintf(stderr, "%d\n", video->frame);

**********************************************************************/
#ifndef __ddxvideo_main_h__
#define __ddxvideo_main_h__

#ifdef  __cplusplus
extern          "C"
{
#endif
#include <ddx.h>

	DDX_STORE_TYPE(DDX_VIDEO, struct
		       {
		       int width; int height; int frame; int fields;	/* Number of fields in frame */
		       unsigned char y[2000000];	/* Maximum image size */
		       unsigned char u[500000];	/* Quarter image */
		       unsigned char v[500000];	/* Quarter image */
		       });
					 
DDX_STORE_TYPE(DDX_VIDEO_1394_PARAMS,
	struct{
		int autoGain;
		int gain;
		int autoExposure;
		int exposure;
		int autoBrightness;
		int brightness;
		int autoShutter;
		int shutter;
		int autoWhiteBalance;
		int whiteBalance[2];
		int autoSharpness;
		int sharpness;
		int autoTemperature;
		int temperature;
		int autoHue;
		int hue;
		int autoSaturation;
		int saturation;
		int autoGamma;
		int gamma;
		int autoTrigger;
		int trigger;
		int autoIris;
		int iris;
		int autoZoom;
		int zoom;
		int autoFocus;
		int focus;
		int autoPan;
		int pan;
		int autoTilt;
		int tilt;
		int autoOpticalFilter;
		int opticalFilter;
		int autoCaptureSize;
		int captureSize;
		int autoCaptureQuality;
		int captureQuality;
});	

					 

/**
* Convert YUV to RGB 
* \warning These value must be ints
*/

#define YUV2RGB(y,u,v,r,g,b)       u -= 128; v -= 128; \
  r = y + ((v*1436) >> 10);        r = r < 0 ? 0 : r; r = r > 255 ? 255 : r; \
  g = y - ((u*352 + v*731) >> 10); g = g < 0 ? 0 : g; g = g > 255 ? 255 : g; \
  b = y + ((u*1814) >> 10);        b = b < 0 ? 0 : b; b = b > 255 ? 255 : b

/**
* Convert RGB to YUV
* \warning These value must be ints
*/

#define RGB2YUV(r,g,b,y,u,v) \
  y = (306*r + 601*g + 117*b)  >> 10;          y = y < 0 ? 0 : y; y = y > 255 ? 255 : y; \
  u = ((-172*r - 340*g + 512*b) >> 10)  + 128; u = u < 0 ? 0 : u; u = u > 255 ? 255 : u; \
  v = ((512*r - 429*g - 83*b) >> 10) + 128;    v = v < 0 ? 0 : v; v = v > 255 ? 255 : v

#ifdef  __cplusplus
}
#endif
#endif
