#!/usr/bin/python
import ddxInterface
import sys
import re
import time
import getopt
from math import *

from Monitor import *

###### Option parsing ###################

def printhelp():
	print "Usage: %s [-h] [-p] [-g] <condition file>" % sys.argv[0]
	print "-p,--protect: load file outside an exception block (debug)"
	print "-g,--gui    : load the gui"
	print "-h,--help   : print this message"
	sys.exit(1)

if (len(sys.argv) < 2):
	printhelp()

opts,args=getopt.getopt(sys.argv[1:],"pgh",["protect","gui","help"])

if (len(args) != 1):
	printhelp()

textonly=True
protect=True
#print opts
for o,a in opts:
	if o == "-g":
		textonly = False
	if o == "-p":
		protect = False
	if o == "-h":
		printhelp()

#######################################################3333###

store = ddxInterface.ddxStore()
monitor = Monitor()
if protect:
	try:
		monitor.load(args[0],store)
	except Exception,inst:
		print "Error opening config file '%s': %s" % (str(args),str(inst))
		sys.exit(1)
else:
	monitor.load(args[0],store)

R=monitor.evaluate()
time.sleep(1.0)


################## Main loop #################

if textonly:
	try:
		while True:
			R=monitor.evaluate()
			#monitor.printEvaluation(R[0],R[1])
			if (len(R['error']) > 0):
				if (len(R['error']) > 1):
					print "%.3f: Warning these conditions are not verified:" % time.time()
				else:
					print "%.3f: Warning this condition is not verified:" % time.time()
				for s in R['error']:
					print "\t" + s
			time.sleep(0.5)
	except Exception,inst:
		print "Monitor interrupted: " + str(inst)
else:
	from CondMonitorGUI import *
	#print "starting GUI"
	MonitorGUI = MonitorGUIMain(monitor,0)
	MonitorGUI.MainLoop()





