
import os

from CondVariable import *
from Condition import *

class Monitor:
	conditions=[]
	ddxvars={}
	numCond = 0

	def __init__(self):
		self.conditions=[]
		self.ddxvars=[]
		self.numCond = 0
		self.files = 0

	def apply_dict(self,s,d):
		for v in d.keys():
			s = re.sub(v,d[v],s)
		return s


	def include(self,fname,subst={}):
		global env
		# to be protected agains infinite recursion
		self.files += 1
		if self.files > 30:
			print "Too many include, or recursive loop"
			return []

		# open file, or look for it in $AUTOM
		possible_name = [ fname,
			"%s/%s" % (os.environ['AUTOM'],fname),
			"%s/etc/%s" % (os.environ['AUTOM'],fname) ]
		for f in possible_name:
			try:
				fp=open(f)
				break
			except: 
				continue


		# Read all in on shot,
		cond = fp.readlines()
		fp.close()

		# Then process line by line
		i = -1
		res = []
		while (i+1 < len(cond)):
			i += 1
			# Remove any white line and apply the translation dictionary
			l = self.apply_dict(cond[i].strip(),subst)
			if (len(l) == 0):
				continue
			if (l[0]=='#') or (l[0]=='%'):
				continue

			# don't accept a line with a single =, we don't want to affect anything
			if (re.search('[^=><!]=[^=]',l)):
				print "line '%s' rejected due to a single '='" % l
				continue

			# identify an include and try to start a recursive call
			if (re.match('\Ainclude(.*)\Z',l)):
				try:
					cond[i:i+1] = eval("self.%s" % l)
					i -= 1
					continue
				except Exception,inst:
					print "Ignored %s: exception '%s'" % (l,str(inst))
			res.append(l)

		return res


	def load(self,fname,store):
		cond = self.include(fname)
		
		vars=set()
		for l in cond:
			c = Condition(l)
			self.conditions.append(c)
			vars.update(c.extractVars())

		for c in self.conditions:
			c.createEvalText(vars)
			
		self.numCond = len(self.conditions)
		print "Monitoring %d condition(s)" % len(self.conditions)
		for l in self.conditions:
			print "\t"+str(l)
		print "Found %d vars" % len(vars)

		self.ddxvars={}
		for v in vars:
			try:
				self.ddxvars[v] = ConditionVariable(store.variable(v))
			except e:
				print "Could not access to variable '%s'" % v
				raise
		
	def evaluate(self):
		lfail=[]
		lsuccess=[]
		for v in self.ddxvars.keys():
			#print "Read '%s'" % v
			self.ddxvars[v].var.read()
			
		for c in self.conditions:
			if c.evaluate(self.ddxvars):
				lsuccess.append(str(c))
			else:
				lfail.append(str(c))
		d={}
		d['error'] = lfail
		d['success'] = lsuccess
		return d

	def numConditions(self):
		return self.numCond

	def printEvaluation(self,fail,success):
		print "Failed conditions:"
		for c in fail:
			print "\t"+str(c)
		print "Successful conditions:"
		for c in success:
			print "\t"+str(c)




		
