
import time

class ConditionVariable:
	def __init__(self,var):
		self.var = var
		self.lastcount = 0
		self.lasttime = -1.0
		self.cfreq = -1.0

	def freq(self):
		cnt = self.var.getCount()
		t = time.time()
		#print "Var %s: t %f c %d" % (self.var.getName(),t,cnt)
		if (self.lasttime < 0):
			self.lasttime = t
			self.lastcount = cnt
			return self.cfreq

		dt = t - self.lasttime
		if (dt == 0):
			return self.cfreq
		dc = cnt - self.lastcount
		if dc > 0:
			self.cfreq = dc/dt
			self.lasttime = t
			self.lastcount = cnt
		else:
			self.cfreq = 1/dt
		return self.cfreq

