#!/usr/bin/env python
# -*- coding: ANSI_X3.4-1968 -*-
# generated by wxGlade 0.4.1 on Sun Aug 27 00:13:04 2006

import wx
import wx.grid


class CondMonitorGUI(wx.Frame):
	def __init__(self, app,  parent):
		self.app = app
		# begin wxGlade: CondMonitorGUI.__init__
		#kwds["style"] = wx.ICONIZE|wx.CAPTION|wx.MINIMIZE|wx.CLOSE_BOX|wx.MINIMIZE_BOX|wx.MAXIMIZE|wx.MAXIMIZE_BOX|wx.SYSTEM_MENU|wx.RESIZE_BORDER
		wx.Frame.__init__(self, parent,wx.ID_ANY,"Condition Monitor")
		self.pause = wx.Button(self, -1, "Pause")
		self.quit = wx.Button(self, -1, "Quit")

		#self.wsymbols = "-/|\\"
		#self.wsymbols = "----------------"
		self.windex = 0
		#self.wheel = wx.StaticText(self,-1,self.wsymbols[0:self.windex]+"|"+self.wsymbols[self.windex+2:])
		self.wheel = wx.Gauge(self,-1,50)

		self.conditions = wx.grid.Grid(id=wx.ID_ANY,parent=self)
		self.conditions.CreateGrid(self.app.monitor.numConditions(),2)
		self.conditions.SetColLabelSize(20)
		self.conditions.SetDefaultRenderer(wx.grid.GridCellAutoWrapStringRenderer())
		self.conditions.SetRowLabelSize(0)
		self.conditions.SetColLabelValue(0,"Condition")
		self.conditions.SetColLabelValue(1,"Status")


		self.__set_properties()
		self.__do_layout()

		self.update_grid()
		self.conditions.Fit()
		self.Fit()

		self.Bind(wx.EVT_BUTTON, self.pause_hdler, self.pause)
		self.Bind(wx.EVT_BUTTON, self.exit_hdler, self.quit)
		self.Bind(wx.EVT_SIZE,self.on_resize,self)

		# end wxGlade

	def __set_properties(self):
		# begin wxGlade: CondMonitorGUI.__set_properties
		#self.SetTitle("Condition Monitor")
		self.SetSize((714, 471))
		# end wxGlade
		pass

	def __do_layout(self):
		# begin wxGlade: CondMonitorGUI.__do_layout
		self.sizer_4 = wx.BoxSizer(wx.VERTICAL)
		self.sizer_5 = wx.BoxSizer(wx.HORIZONTAL)
		self.sizer_5.Add(self.pause)
		self.sizer_5.Add(self.quit)
		self.sizer_4.Add(self.sizer_5)
		self.sizer_4.Add(self.conditions)
		self.sizer_4.Add(self.wheel,-1,wx.CENTER | wx.ALIGN_CENTER_VERTICAL |
				wx.EXPAND)

		self.SetSizer(self.sizer_4)
		#self.SetAutoLayout(True)
		self.Layout()
		# end wxGlade
		pass

	def on_resize(self,event):
		wz = self.GetSize()
		# Condition size
		ss = wz.width * 0.25
		if (ss > 75):
			ss = 75
		self.conditions.SetColSize(0,int(wz.width-ss))
		self.conditions.SetColSize(1,int(ss))
		sz = wx.Size()
		sz.width = wz.width
		sz.height= wz.height - self.pause.GetSize().height - 10
		self.conditions.SetSize(sz)
		self.conditions.SetMinSize(sz)
		self.conditions.AutoSizeRows(True)

		# wheel size
		self.wheel.SetMinSize(wx.Size(wz.width,10))
		self.Layout()
		event.Skip()

	def pause_hdler(self, event): # wxGlade: CondMonitorGUI.<event_handler>
		if self.app.timer.IsRunning():
			self.app.timer.Stop()
			self.pause.SetLabel("Resume")
		else:
			self.app.timer.Start(500,False)
			self.pause.SetLabel("Pause")

	def exit_hdler(self, event): # wxGlade: CondMonitorGUI.<event_handler>
		self.Close(True)

	def update_grid(self):
		R = self.app.monitor.evaluate()
		index = 0
		for c in R['error']:
			self.conditions.SetCellValue(index,0,c)
			self.conditions.SetCellValue(index,1,"FAIL")
			self.conditions.SetCellBackgroundColour(index,1,"RED")
			self.conditions.SetCellAlignment(index,1,wx.ALIGN_CENTRE,wx.ALIGN_CENTRE)
			index += 1
		for c in R['success']:
			self.conditions.SetCellValue(index,0,c)
			self.conditions.SetCellValue(index,1,"OK")
			self.conditions.SetCellBackgroundColour(index,1,"GREEN")
			self.conditions.SetCellAlignment(index,1,wx.ALIGN_CENTRE,wx.ALIGN_CENTRE)
			index += 1

		self.conditions.AutoSizeRows(True)
		#self.windex = (self.windex + 1) % len(self.wsymbols)
		#self.wheel.SetLabel(self.wsymbols[0:self.windex]+"|"+self.wsymbols[self.windex+2:])
		self.windex = (self.windex + 1) % (self.wheel.GetRange()+1)
		self.wheel.SetValue(self.windex)



# end of class CondMonitorGUI


class MonitorGUIMain(wx.App):

	def __init__(self,monitor,opt):
		self.monitor = monitor
		wx.App.__init__(self,opt)
		self.timer = wx.Timer()
		self.timer.Start(500,False)
		self.Bind(wx.EVT_TIMER,self.on_timer)

	def OnInit(self):
		wx.InitAllImageHandlers()
		self.mainframe = CondMonitorGUI(self,None)
		self.SetTopWindow(self.mainframe)
		self.mainframe.Show(1)
		return 1

	def on_timer(self,event):
		self.mainframe.update_grid()
		

# end of class MonitorGUIMain


#if __name__ == "__main__":
#	MonitorGUI = MonitorGUIMain(0)
#	MonitorGUI.SetMonitor(monitor)
#	MonitorGUI.Update()
#	MonitorGUI.MainLoop()
