/**Signature>
* Author       : Cedric Pradalier 
* Organisation : CSIRO
* Email        : cedric.pradalier@csiro.au
* Contexte     : Post-doctoral fellowship
* Date         : 12/2004
<Signature**/
#ifndef DDX_VARIABLE_H
#define DDX_VARIABLE_H

#include "ddxInterface.h"
#include <rtx/parse.h>
#include <rtx/error.h>

typedef struct ddx_variable {
    PyObject_HEAD
    /* Type-specific fields go here. */
	int owneditem;
	struct ddx_variable * toplevel;
	DDX_STORE_ITEM * item;
	RtxParseVar * var;
	void * buffer;
	unsigned int offset;
	unsigned int size;
	unsigned int dim;
	signed int * arrayDim;
	double * timestamp;
	int direct;
} ddxVariable;

extern PyTypeObject ddx_VariableType;

extern PyObject * ddxVariable_Create(DDX_STORE_ITEM * item, 
		RtxParseVar * pvar, int direct);

extern PyObject * buildDefinition(PyObject * s,
		RtxParseVar * v,unsigned int dim,int * arrayDim,
		unsigned int indentLevel, int pretty, void * buffer);
#endif // DDX_VARIABLE_H
