/**Signature>
* Author       : Cedric Pradalier 
* Organisation : CSIRO
* Email        : cedric.pradalier@csiro.au
* Contexte     : Post-doctoral fellowship
* Date         : 12/2004
<Signature**/
#include "ddxInterface.h"

#include "ddxVariable.h"
#include "ddxStore.h"
static PyMethodDef ddx_module_methods[] = {
    {NULL}  /* Sentinel */
};


#ifndef PyMODINIT_FUNC	/* declarations for DLL import/export */
#define PyMODINIT_FUNC void
#endif
PyMODINIT_FUNC
initddxInterface(void) 
{
    PyObject* m;


    m = Py_InitModule3("ddxInterface", ddx_module_methods,
                       "Module that implement DDX variable interface");

    if (PyType_Ready(&ddx_StoreType) < 0)
        return;

    Py_INCREF(&ddx_StoreType);
    PyModule_AddObject(m, "ddxStore", (PyObject *)&ddx_StoreType);

    ddx_VariableType.tp_new = PyType_GenericNew;
    if (PyType_Ready(&ddx_VariableType) < 0)
        return;

    Py_INCREF(&ddx_VariableType);
    PyModule_AddObject(m, "ddxVariable", (PyObject *)&ddx_VariableType);

}
