#!/usr/bin/python
import ddxInterface
import atexit
import sys

sys.ps1="\nddxpy# "

# Using default value to open connection
store = ddxInterface.ddxStore() 

def tlist():
	print store.types

def type():
	print store.types

def var():
	print store.variables

def ls():
	print store.variables

def vlist():
	print store.variables
	
def const():
	print store.constants

def clist():
	print store.constants

def vstatus(name):
	variable = store.variable(name)
	print variable.getDefinition()

def cstatus(name):
	print store.constant(name)

def tstatus(name):
	print store.type(name)

def value(name):
	variable = store.variable(name)
	variable.read()
	print repr(variable)

def get(name):
	return store.variable(name)

def watch(name,delay=2,detail=False,raw=False):
	"""Display a variable value every 'delay' seconds"""
	variable = store.variable(name)
	variable.watch(delay,detail,raw)
	
def watchl(name,delay=2,raw=False):
	"""Display a variable value every 'delay' seconds"""
	variable = store.variable(name)
	variable.watch(delay,True,raw)
	
	

def help():
	print "\n\n---- Available commands ----"
	print "ls()/vlist()/var() : list the variables in the store"
	print "clist()/const()    : list the constants in the store"
	print "tlist()/type()     : list the types in the store"
	print "vstatus(name)      : print the type definition of variable name"
	print "tstatus(name)      : print the definition of type name"
	print "cstatus(name)      : print the value of constant name"
	print "value(name)        : print the value of variable name"
	print "watch(name,delay,detail,raw) : keep displaying name's value "
	print "                   : using repr (or str if raw) every delay seconds,"
	print "                   : with more details if detail is True"
	print "                   : default: delay=2s, detail=raw=false"
	print "watchl(name,delay,raw) : as above with detail=true"
	print "V = get(name)      : returns a handle for variable name"
	print "                   : type helpvar() for more information"

def helpvar():
	print "---- Variable handle object ----"
	print "V.<name> or V[idx] : create an alias to a part of the object"
	print "V.member = <value> : affect value to V, must be integer or string"
	print "repr(V), str(V)    : textual representation of V"
	print "len(V)             : length of V, if V is an array"
	print "int(V), long(V)    : try to extract the value of V as an integer"
	print "float(V)           :  try to extract the value of V as a float"
	print "V.read(double time,int skipframe) : read V from the store, V's "
	print "                   : value is undefined before that"
	print "V.write()          : write V's current state to the store"
	print "V.set(value)       : as operator '='"
	print "V.getTimeStamp()   : return V's time stamp (surprise!)"
	print "V.getSize()        : return V's size in the store"
	print "V.getDefinition()  : return V's type definition"
	print "V.getBuffer()      : return V's current raw buffer (void*)"
	print "V.watch(delay,detail,raw) : see watch above"


import sys
if (len(sys.argv) > 1):
    arglist=sys.argv[1:]
    #print arglist
    for i in arglist:
	#print i
	f=open(i,"r")
	exec f
	del f
else:
	help()


