
#include <ddx.h>
#include "ddxjoystick.h"
#include <rtx/error.h>
#include <stdio.h>

DDX_JOYSTICK         joystick;
DDX_STORE_ID   * storeId = NULL;
DDX_STORE_ITEM * joyReadPtr = NULL;

int main (int argc, char **argv)
{
  int i=0;

  if ((storeId = ddx_store_open (NULL, 0, 5)) == NULL)
    return rtx_error ("Unable to open store");
  
  if (DDX_STORE_REGISTER_TYPE (storeId, DDX_JOYSTICK) == -1)
    return rtx_error ("Unable to register type");
  
  if ((joyReadPtr = 
    ddx_store_lookup_item (storeId,"joystick","DDX_JOYSTICK",0)) == NULL) 
    return rtx_error ("Unable to lookup var");

  for(i=0;i<joystick.na;i++) printf("Axes%d ", i);	
  for(i=0;i<joystick.nb;i++) printf("%d ",i);
  printf("\n");
  fflush(stdout);

  while (1)
    {
    if (ddx_store_read (joyReadPtr, &joystick, NULL, 10.0, 1) == -1)
	return rtx_error ("Unable to read var ");

    for(i=0;i<joystick.na;i++) printf("%6d ",joystick.axes[i]);	
    for(i=0;i<joystick.nb;i++) printf("%d ",joystick.buttons[i]);
    printf("\r");
    fflush(stdout);
    }

  ddx_store_done_item (joyReadPtr);
  ddx_store_close (storeId);
  ddx_client_done ();
  return (1);
}
