/******************************************************************************
* Simple program to test joystick
* Under Linux, the joystick should appear as /dev/input/js? device
* It it does not work, check lsmod of joydev device driver
******************************************************************************/

#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>

#include <linux/joystick.h>
#include <rtx/error.h>
#include <rtx/getopt.h>

int main (int argc, char **argv)
{
  int i, fd;
  unsigned char na = 2;
  unsigned char nb = 2;
  int version = 0x000800;
  int  *axis;
  char *button;
  struct js_event js;  
  char name[128];

  if( argc != 2 ) { fprintf(stderr, "%s devicename\n", argv[0]); exit(-1); }
  if ((fd = open(argv[1], O_RDONLY)) < 0) { perror("ddxjoystick"); exit(-1); }

  ioctl(fd, JSIOCGVERSION, &version);
  ioctl(fd, JSIOCGAXES,    &na);	// Get Number of Axis 
  ioctl(fd, JSIOCGBUTTONS, &nb);	// Get Number of Buttons 
  ioctl(fd, JSIOCGNAME(128), name);
  
  printf("Joystick (%s) has %d axes and %d buttons ", name, na, nb);
  printf("Driver version is %d.%d.%d.\n", version >> 16, 
     (version >> 8) & 0xff, version & 0xff);
  
  axis = calloc(na, sizeof(int));
  button = calloc(nb, sizeof(char));

  while (1) {
    if (read(fd, &js, sizeof(struct js_event)) != sizeof(struct js_event)) 
      { perror("\nJoystick: error reading"); exit(-1); }
    
    switch( js.type & ~JS_EVENT_INIT ) {
      case JS_EVENT_AXIS:   axis[js.number]   = js.value; break;
      case JS_EVENT_BUTTON: button[js.number] = js.value; break;
      default: break;
      }

    if (na) for(i=0; i<na; i++) printf("%6d ", axis[i]); 
    if (nb) for(i=0; i<nb; i++) printf("%d ", button[i]); 
    printf("\r");
  }
  exit(0);
}
 
