#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>

#include <linux/joystick.h>

#include <ddx.h>
#include "ddxjoystick.h"
#include <rtx/error.h>
#include <rtx/main.h>
#include <rtx/signal.h>
#include <rtx/getopt.h>
#include <rtx/timer.h>
#define KILLER_PRIO RTX_THREAD_PRIO_MIN

DDX_JOYSTICK joystick;
DDX_STORE_ID   * storeId = NULL;
DDX_STORE_ITEM * joyPtr = NULL;
RtxThread   *joystickThread;
void joystick_thread(void);

RtxThread   *writeThread;
void write_thread(void);
double sampleTime = 0.1;
char *dev = "/dev/input/js0";

/* command line options */
RtxGetopt	options[] = {
	{"dev", "device name",
		{
			{RTX_GETOPT_STR, &dev, "dev"},
			RTX_GETOPT_END_ARG
		}	
	},
	RTX_GETOPT_END
};

int fd;

int main (int argc, char **argv)
{
	int ret;
	
	
	/* Process command line options (avs custom)*/
	ret = RTX_GETOPT_CMD (options, argc, argv, "", "joystick for ddx application\n");
	sampleTime = rtx_getopt_get_sample(sampleTime);

	if (ret < 0)
		exit(ret);
	fprintf(stderr, "ddxjoystick store write loop time is %.2f\n", sampleTime);
  if ((fd = open(dev, O_RDONLY)) < 0) { perror("ddxjoystick"); exit(-1); }
 
  /* Initialise messsage and error protocols */
  rtx_main_init(argv[0], RTX_ERROR_STDERR);

  if ((storeId = ddx_store_open (NULL, 0, 5)) == NULL)
    return rtx_error ("Unable to open store");
  
  if (DDX_STORE_REGISTER_TYPE (storeId, DDX_JOYSTICK) == -1)
    return rtx_error ("Unable to register type");
  
  if ((joyPtr = ddx_store_lookup_item(storeId,"joystick","DDX_JOYSTICK",0)) == NULL)
    return rtx_error ("Unable to lookup var");

  /* Initialise joystick structure to 0 */
  memset(&joystick, 0, sizeof(joystick));

  /* Start threads */
  if((joystickThread = rtx_thread_create("ddyjoystick  thread", 0, RTX_THREAD_SCHED_OTHER, RTX_THREAD_PRIO_MIN, 0, RTX_THREAD_CANCEL_ASYNCHRONOUS, (void*(*)(void*))joystick_thread, NULL, NULL, NULL))==NULL)
		return rtx_error("%s: rtx_thread_create(joystickThread) failed", argv[0]);

  if((writeThread = rtx_thread_create("ddyjoystick write thread", 0,
	RTX_THREAD_SCHED_OTHER, RTX_THREAD_PRIO_MIN, 0, RTX_THREAD_CANCEL_ASYNCHRONOUS,
	(void*(*)(void*))write_thread, NULL, NULL, NULL))==NULL)
		return rtx_error("%s: rtx_thread_create(writeThread) failed", argv[0]);

  /* Wait for shutdown signal */
  rtx_main_wait_shutdown(KILLER_PRIO);
    
  ddx_store_done_item (joyPtr);
  ddx_store_close (storeId);
  ddx_client_done ();
  fprintf(stderr, "Teminating ddxjoystick ...\n");
	return(0);
}
int loopOK = 1;


/**
 * Talks to the joystick 
 */
void
joystick_thread(void)
{
  unsigned char na = 2;
  unsigned char nb = 2;
  struct js_event js;  
 
  int version = 0x000800;
  char name[128];

  ioctl(fd, JSIOCGVERSION, &version);
  ioctl(fd, JSIOCGAXES,    &na);
  ioctl(fd, JSIOCGBUTTONS, &nb);
  ioctl(fd, JSIOCGNAME(128), name);
  
  joystick.na = na;
  joystick.nb = nb;
  while (loopOK) {
    if (read(fd, &js, sizeof(struct js_event)) != sizeof(struct js_event)) {
			perror("Error reading "); 
			loopOK = 0;
			continue;
	 	}
    
    switch(js.type & ~JS_EVENT_INIT) 
      {
      case JS_EVENT_BUTTON: joystick.buttons[js.number]=js.value; break;
      case JS_EVENT_AXIS: joystick.axes[js.number]=js.value; break;
      }
    
  }
  rtx_main_signal_shutdown();
}


/* 
 * Talks to the store.
 */
void
write_thread(void)
{
	RtxTimer *timer;        

	/* Create timer. */
	timer = rtx_timer_create(0.02,sampleTime, NULL, NULL, 0);
	rtx_timer_start(timer);
	
	while (loopOK) {
		if (rtx_timer_wait(timer) == -1){
			rtx_error_flush ("write_thread: rtx_timer_wait() failed");
			loopOK = 0;  
			continue;
		}
 		if (ddx_store_write (joyPtr, &joystick, NULL) == -1){
			loopOK = 0;
			rtx_error_flush ("Unable to write var ");
			continue;
		}	
	}	
  rtx_main_signal_shutdown();
} 



