#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "ddx.h"


/**
 * Create a new DDX_STRING_LIST object to store "name" and attach it as
 * "list->next" Then returns list->next for further attachment
 * **/
DDX_STRING_LIST * ddx_stringlist_attachafter(DDX_STRING_LIST * list,
		const char * name)
{
	DDX_STRING_LIST * block = (DDX_STRING_LIST*)malloc(sizeof(DDX_STRING_LIST));
	block->name = strdup(name);
	assert(block->name != NULL);
	block->next = NULL;
	assert(list->next == NULL);
	list->next = block;
	return block;
}

/**
 * Create a new DDX_STRING_LIST object to store "name" and attach "list" 
 * to its "next" field. Returns the new object
 * **/
DDX_STRING_LIST * ddx_stringlist_pushfront(DDX_STRING_LIST * list,
		const char * name)
{
	DDX_STRING_LIST * block = (DDX_STRING_LIST*)malloc(sizeof(DDX_STRING_LIST));
	block->name = strdup(name);
	assert(block->name != NULL);
	block->next = list;
	return block;
}

/**
 * Concatenate all the strings contains in list into one big string
 * This string is newly allocated with malloc, and consequently,
 * should be freed later on
 * **/
char * ddx_stringlist_concatenate(DDX_STRING_LIST * list)
{
	char * result;
	unsigned int length = 0;
	DDX_STRING_LIST * block = list;
	while (block != NULL) {
		length += strlen(block->name);
		block = block->next;
	}
	//printf("Concatenate: length = %d\n",length);
	result = (char*)malloc((length+1)*sizeof(char));
	result[0] = 0;
	block = list;
	while (block != NULL) {
		strcat(result,block->name);
		//printf("Concatenate: it = %s\n",result);
		block = block->next;
	}
	//printf("Concatenate: result = %s\n",result);
	return result;
}

/**
 * Recursively free list and all the DDX_STRING_LIST linked to list
 * **/
void ddx_stringlist_free(DDX_STRING_LIST * list) 
{
	DDX_STRING_LIST *block = list, *tmp;
	while (block != NULL) {
		free(block->name);
		tmp = block->next;
		free(block);
		block = tmp;
	}
}






