#include <stdlib.h>
#include <stdio.h>

#include <rtx/error.h>

#include "ddx.h"


int main()
{
	DDX_STORE_ID *store;
	DDX_STORE_ITEM *item;
	DDX_STRING_LIST *ls;

	if (ddx_client_init(0) < 0) {
	  rtx_error_flush("failed to initialise ddx");
	  exit(EXIT_FAILURE);
	}

	if (! (store = ddx_store_open(NULL,0,3))) {
	  rtx_error_flush("failed to connect to store");
	  exit(EXIT_FAILURE);
	}

	ls = ddx_store_get_variable_list(store);
	
	while (ls) {
		item = ddx_store_lookup_item(store,ls->name,NULL,0);
		if (item) {
			printf("Item %-20s: Count %d\tSize\t%d\tQueue\t%d\tOffset %d\n",
					ls->name, 
					item->headerP->count, 
					item->varSize, 
					item->headerP->queueLength,
					item->headerP->shmOffset);
		} else {
			printf("Item %-20s: Lookup failed\n",ls->name);
		}
		ddx_store_done_item(item);
		ls = ls->next;
	}
	ddx_stringlist_free(ls);
	ddx_store_close(store);
	ddx_client_done();
	return 0;
}

