
/***********************************************************************
 * store-msg.h - header file for store-msg module
 *
 * CSIRO MANUFACTURING SCIENCE & TECHNOLOGY
 * HIGH-SPEED SERIAL INTERFACE PROJECT
 * 
 * $Id: store-msg.h 2200 2007-11-23 05:46:38Z roy029 $
 * 
 * Copyright (c) CSIRO Manufacturing Science & Technology.
 *
 ***********************************************************************
 */

#ifndef __store_msg_h__
#define __store_msg_h__

#define MAX_MSG_TOK_LEN 64
#define MAX_MSG_LEN 16

#define MSG_TOK_NONE                                   (-1)

typedef struct _keyword_table_entry {
    int       id;
    char      name[MAX_MSG_TOK_LEN];
    int       options;
} KEYWORD_TABLE_ENTRY;

typedef struct _msg_item {
    int       id;
    int       optional;
} MSG_ITEM;

typedef struct _msg_table_entry {
    int       id;
    int       numItems;
    MSG_ITEM  msgItem[MAX_MSG_LEN];
} MSG_TABLE_ENTRY;

typedef struct _msg_part {
    int       id;
    char      * val;
} MSG_PART;

typedef struct _msg {
    int       id;
    int       numParams;
    MSG_PART  msgPart[MAX_MSG_LEN];
} MSG;

int get_keyword (KEYWORD_TABLE_ENTRY * keyTab, char * s);
void free_message (KEYWORD_TABLE_ENTRY * keyTab, MSG * mp);
int get_next_message_token (char * s, char * sep, int * tokStart,
			    int * tokEnd, char * tok);
MSG * parse_message (KEYWORD_TABLE_ENTRY * keyTab, char * s);
int identify_message (MSG_TABLE_ENTRY * msgTab,	MSG * msg);
char * get_message_part (KEYWORD_TABLE_ENTRY * keyTab, MSG * msg, int itemId);

#endif
