
/***********************************************************************
 * store-msg.c - functions to parse messages
 *
 * CSIRO MANUFACTURING SCIENCE & TECHNOLOGY
 * HIGH-SPEED SERIAL INTERFACE PROJECT
 * 
 * $Id: store-msg.c 2200 2007-11-23 05:46:38Z roy029 $
 * 
 * Copyright (c) CSIRO Manufacturing Science & Technology.
 *
 ***********************************************************************
 */

#ifdef __GNUC__
#define DDX_STATIC_ATTRIBUTE __attribute__((unused))
#else
#define DDX_STATIC_ATTRIBUTE
#endif
static char *rcsid DDX_STATIC_ATTRIBUTE = "$Id: store-msg.c 2200 2007-11-23 05:46:38Z roy029 $";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <rtx/message.h>
#include "store-msg.h"

static char sep[] = " \t\f\r\v\n=";

int
get_keyword (
        KEYWORD_TABLE_ENTRY * keyTab,
        char * s
    )
{
    int i;

    for (i=0; keyTab[i].id != -1; i++)
        if (strcmp (s, keyTab[i].name) == 0)
	    return (keyTab[i].id);
    return (-1);
}

void
free_message (
        KEYWORD_TABLE_ENTRY * keyTab,
	MSG * mp
    )
{
    int i;
    
    if (mp == NULL)
        return;
	for (i=0; i<mp->numParams; i++) {
		if (keyTab[mp->msgPart[i].id].options) {
			if (mp->msgPart[i].val != NULL) {
				free (mp->msgPart[i].val);
			}
		}
	}
    free (mp);
}

int
get_next_message_token (
        char * s,
	char * sep,
	int * tokStart,
	int * tokEnd,
	char * tok
    )
{
    int i, j = * tokStart, k = * tokEnd;
    
    /* Skip to first char of next token */
    for (i=k; (s[i] != '\0') && (strchr (sep, s[i]) != NULL); i++);

    /* Find end of token */
    for (j=i; (s[j] != '\0') && (strchr (sep, s[j]) == NULL); j++)
        tok[j-i] = s[j];
    tok[j-i] = '\0';

    /* Now, i = first char of token, 
     * j = one past last char of token.
     */
    if (j != i) {
        * tokStart = i;
	* tokEnd = j;
	return (0);
    }
    /* no more tokens */
    return (-1);
}

MSG *
parse_message (
        KEYWORD_TABLE_ENTRY * keyTab,
	char * s
    )
{
	char tok[1024];
	MSG * m = NULL;
	int tokId;
	int t1 = 0, t2 = 0, t1p, t2p;
	int valStart, res;
	char savedChar;

	if (strlen (s) == 0)
		return (NULL);
	m = NULL;
	if ((m = (MSG *) calloc (1, sizeof (MSG))) == NULL)
		return (NULL);


	m->id = -1;
	m->numParams = 0;
	while (get_next_message_token (s, sep, &t1, &t2, tok) != -1) {
		if ((tokId = get_keyword (keyTab, tok)) == -1) {
			free_message (keyTab, m);
			return (NULL);
		}
		m->msgPart[m->numParams].id = tokId;
		if (keyTab[tokId].options) {
			if (get_next_message_token (s, sep, &t1, &t2, tok) == -1) {
				free_message (keyTab, m);
				return (NULL);
			}
			valStart = t1;
			t1p = t1; t2p = t2;
			while ((res = get_next_message_token (s, sep, &t1, &t2, tok))
					!= -1) {
				if ((tokId = get_keyword (keyTab, tok)) != -1)
					break;
				t1p = t1; t2p = t2;
			}
			if (res != -1) {
				t1 = t1p; t2 = t2p;
			}
			savedChar = s[t2];
			s[t2] = '\0';
			m->msgPart[m->numParams].val = strdup (&(s[valStart]));
			s[t2] = savedChar;
		}
		m->numParams++;
	}
	return (m);
}

int
identify_message (
        MSG_TABLE_ENTRY * msgTab,
	MSG * msg
    )
{
    int i, j, msgid = -1, parmid, parts[MAX_MSG_LEN];

    for (i=0; msgTab[i].msgItem[0].id != -1; i++)
        if (msgTab[i].msgItem[0].id == msg->msgPart[0].id) {
	    msgid = i;
	    break;
	}

    if (msgid == -1) {
        rtx_message_warning ("identify_message: invalid message id = %d", 
		msg->msgPart[0].id);
        return (-1);
    }

    for (i=0; i<MAX_MSG_LEN; i++)
        parts[i] = 1;
    parts[0] = 0;

    msg->id = msgid;
    for (i=1; i < msg->numParams; i++) {
        parmid = -1;
        for (j=1; msgTab[msgid].msgItem[j].id != -1; j++) {
  	    if (parts[j] && 
		    (msgTab[msgid].msgItem[j].id == msg->msgPart[i].id)) {
	        parmid = j;
		parts[j] = 0;
	        break;
	    }
	}
	if (parmid == -1) {
	    rtx_message_warning ("identify_message: invalid parameter id = %d", 
		    msg->msgPart[i].id);
	    return (-1);
	}
    }
    for (i=1; i<msgTab[msgid].numItems; i++)
        if (parts[i] && (msgTab[msgid].msgItem[i].optional != 0)) {
	    rtx_message_warning ("identify_message: missing parameter, id = %d",
		    msgTab[msgid].msgItem[i].id);
	    return (-1);
	}

    return (0);
}

char *
get_message_part (
        KEYWORD_TABLE_ENTRY * keyTab,
	MSG * msg,
	int itemId
    )
{
    int i, found = 0;

    for (i=1; i < msg->numParams; i++) {
        if (msg->msgPart[i].id == itemId) {
	    found = i;
	    break;
	}
    }
    if (found) {
        if (keyTab[itemId].options) {
  	    return (msg->msgPart[found].val);
	} else {
  	    return ((char *) msg);
	}
    }
    return (NULL);
}

void
print_message (
	       KEYWORD_TABLE_ENTRY * keyTab,
	       MSG * msg
	)
{
    int i;

    fprintf (stderr, "\n-------------------\n");
    fprintf (stderr, "msg: numParms = %d\n", msg->numParams);
    for (i=0; i<msg->numParams; i++) {
        fprintf (stderr, "msg: %d parmId = %d", i, msg->msgPart[i].id);
	if (keyTab[msg->msgPart[i].id].options)
  	    fprintf (stderr, ", parmVal = %s", msg->msgPart[i].val);
	fprintf (stderr, "\n");
    }
    fprintf (stderr, "-------------------\n");
}

