
/***********************************************************************
 * store-messages.h - header file for store-messages module
 *
 * CSIRO MANUFACTURING SCIENCE & TECHNOLOGY
 * HIGH-SPEED SERIAL INTERFACE PROJECT
 * 
 * $Id: store-messages.h 2200 2007-11-23 05:46:38Z roy029 $
 * 
 * Copyright (c) CSIRO Manufacturing Science & Technology.
 *
 ***********************************************************************
 */

#ifndef __store_messages_h__
#define __store_messages_h__

#define MSG_TOK_STORE_OPEN_REQUEST                     0
#define MSG_TOK_STORE_OPEN_REPLY                       1
#define MSG_TOK_STORE_REGISTER_CONST_REQUEST           2
#define MSG_TOK_STORE_REGISTER_CONST_REPLY             3
#define MSG_TOK_STORE_REGISTER_TYPE_REQUEST            4
#define MSG_TOK_STORE_REGISTER_TYPE_REPLY              5
#define MSG_TOK_STORE_START_MULTICAST_REQUEST          6
#define MSG_TOK_STORE_START_MULTICAST_REPLY            7
#define MSG_TOK_STORE_LOOKUP_VAR_REQUEST               8
#define MSG_TOK_STORE_LOOKUP_VAR_REPLY                 9
#define MSG_TOK_STORE_STOP_MULTICAST_REQUEST           10
#define MSG_TOK_STORE_STOP_MULTICAST_REPLY             11
#define MSG_TOK_STORE_DONE_VAR_REQUEST                 12
#define MSG_TOK_STORE_DONE_VAR_REPLY                   13
#define MSG_TOK_STORE_CLOSE_REQUEST                    14
#define MSG_TOK_STORE_CLOSE_REPLY                      15
#define MSG_TOK_RESPONSE                               16
#define MSG_TOK_ID                                     17
#define MSG_TOK_NAME                                   18
#define MSG_TOK_VALUE                                  19
#define MSG_TOK_VAR_DEFINITION                         20
#define MSG_TOK_TYPE_DEFINITION                        21
#define MSG_TOK_SHMEM_NAME                             22
#define MSG_TOK_SHMEM_ID                               23
#define MSG_TOK_SHMEM_SIZE                             24
#define MSG_TOK_SHMEM_PID                              25
#define MSG_TOK_SHMEM_VAR_OFFSET                       26
#define MSG_TOK_SHMEM_VAR_HEADER_OFFSET                27
#define MSG_TOK_SYNC_SEM_ID                            28
#define MSG_TOK_SEM_POOL_NAME                          29
#define MSG_TOK_SEM_POOL_SIZE                          30
#define MSG_TOK_STORE_PID                              31
#define MSG_TOK_STORE_ERROR_REPLY                      32
#define MSG_TOK_MESSAGE_ID                             33
#define MSG_TOK_SHMEM_VAR_ID                           34
#define MSG_TOK_SHMEM_VAR_SIZE                         35
#define MSG_TOK_SYNC_SEM_ALLOCATE                      36
#define MSG_TOK_MULTICAST_REQUIRED                     37
#define MSG_TOK_VAR_MULTICAST_ADDRESS                  38
#define MSG_TOK_VAR_MULTICAST_PORT                     39
#define MSG_TOK_LIST                                   40
#define MSG_TOK_STORE_GET_CATALOG_REQUEST              41
#define MSG_TOK_STORE_GET_CATALOG_REPLY                42
#define MSG_TOK_STORE_GET_VAR_LIST_REQUEST             43
#define MSG_TOK_STORE_GET_VAR_LIST_REPLY               44
#define MSG_TOK_STORE_GET_VAR_STATUS_REQUEST           45
#define MSG_TOK_STORE_GET_VAR_STATUS_REPLY             46
#define MSG_TOK_STORE_GET_VAR_VALUE_REQUEST            47
#define MSG_TOK_STORE_GET_VAR_VALUE_REPLY              48
#define MSG_TOK_STORE_SET_VAR_VALUE_REQUEST            49
#define MSG_TOK_STORE_SET_VAR_VALUE_REPLY              50
#define MSG_TOK_LOCAL_LOOKUP                           51
#define MSG_TOK_ITEM_TYPE_VAR                          52
#define MSG_TOK_ITEM_TYPE_TYPE                         53
#define MSG_TOK_ITEM_TYPE_CONST                        54
#define MSG_TOK_STORE_LOOKUP_FIELD_REQUEST             55
#define MSG_TOK_STORE_LOOKUP_FIELD_REPLY               56
#define MSG_TOK_SYNC_SYSVSEM_ID                        57
#define MSG_TOK_STORE_SET_VAR_QUEUE_REQUEST            58
#define MSG_TOK_STORE_SET_VAR_QUEUE_REPLY              59

#define MSG_STORE_OPEN_REQUEST                         0
#define MSG_STORE_OPEN_REPLY                           1
#define MSG_STORE_REGISTER_CONST_REQUEST               2
#define MSG_STORE_REGISTER_CONST_REPLY                 3
#define MSG_STORE_REGISTER_TYPE_REQUEST                4
#define MSG_STORE_REGISTER_TYPE_REPLY                  5
#define MSG_STORE_START_MULTICAST_REQUEST              6
#define MSG_STORE_START_MULTICAST_REPLY                7
#define MSG_STORE_LOOKUP_VAR_REQUEST                   8
#define MSG_STORE_LOOKUP_VAR_REPLY                     9
#define MSG_STORE_STOP_MULTICAST_REQUEST               10
#define MSG_STORE_STOP_MULTICAST_REPLY                 11
#define MSG_STORE_DONE_VAR_REQUEST                     12
#define MSG_STORE_DONE_VAR_REPLY                       13
#define MSG_STORE_CLOSE_REQUEST                        14
#define MSG_STORE_CLOSE_REPLY                          15
#define MSG_STORE_ERROR_REPLY                          16
#define MSG_STORE_GET_CATALOG_REQUEST                  17
#define MSG_STORE_GET_CATALOG_REPLY                    18
#define MSG_STORE_GET_VAR_LIST_REQUEST                 19
#define MSG_STORE_GET_VAR_LIST_REPLY                   20
#define MSG_STORE_GET_VAR_STATUS_REQUEST               21
#define MSG_STORE_GET_VAR_STATUS_REPLY                 22
#define MSG_STORE_GET_VAR_VALUE_REQUEST                23
#define MSG_STORE_GET_VAR_VALUE_REPLY                  24
#define MSG_STORE_SET_VAR_VALUE_REQUEST                25
#define MSG_STORE_SET_VAR_VALUE_REPLY                  26
#define MSG_STORE_LOOKUP_FIELD_REQUEST                 27
#define MSG_STORE_LOOKUP_FIELD_REPLY                   28
#define MSG_STORE_SET_VAR_QUEUE_REQUEST                29
#define MSG_STORE_SET_VAR_QUEUE_REPLY                  30

extern KEYWORD_TABLE_ENTRY keyTable[];
extern MSG_TABLE_ENTRY msgTable [];

#endif
