
/***********************************************************************
 * store-messages.c - ddx store messages
 *
 * CSIRO MANUFACTURING SCIENCE & TECHNOLOGY
 * HIGH-SPEED SERIAL INTERFACE PROJECT
 * 
 * $Id: store-messages.c 2200 2007-11-23 05:46:38Z roy029 $
 * 
 * Copyright (c) CSIRO Manufacturing Science & Technology.
 *
 ***********************************************************************
 */

#ifdef __GNUC__
#define DDX_STATIC_ATTRIBUTE __attribute__((unused))
#else
#define DDX_STATIC_ATTRIBUTE
#endif
static char *rcsid DDX_STATIC_ATTRIBUTE = "$Id: store-messages.c 2200 2007-11-23 05:46:38Z roy029 $";

#include "store-msg.h"
#include "store-messages.h"

KEYWORD_TABLE_ENTRY keyTable[] = {
    /* MSG_TOK_STORE_OPEN_REQUEST 0*/
    {0, "$$storeOpenRequest", 0},
    /* MSG_TOK_STORE_OPEN_REPLY 1 */
    {1, "$$storeOpenReply", 0},
    /* MSG_TOK_STORE_REGISTER_CONST_REQUEST 2 */
    {2, "$$storeRegisterConstRequest", 0},
    /* MSG_TOK_STORE_REGISTER_CONST_REPLY 3 */
    {3, "$$storeRegisterConstReply", 0},
    /* MSG_TOK_STORE_REGISTER_TYPE_REQUEST 4 */
    {4, "$$storeRegisterTypeRequest", 0},
    /* MSG_TOK_STORE_REGISTER_TYPE_REPLY 5 */
    {5, "$$storeRegisterTypeReply", 0},
    /* MSG_TOK_STORE_START_MULTICAST_REQUEST 6 */
    {6, "$$storeStartMulticastRequest", 0},
    /* MSG_TOK_STORE_START_MULTICAST_REPLY 7 */
    {7, "$$storeStartMulticastReply", 0},
    /* MSG_TOK_STORE_LOOKUP_VAR_REQUEST 8 */
    {8, "$$storeLookupVarRequest", 0},
    /* MSG_TOK_STORE_LOOKUP_VAR_REPLY 9 */
    {9, "$$storeLookupVarReply", 0},
    /* MSG_TOK_STORE_STOP_MULTICAST_REQUEST 10 */
    {10, "$$storeStopMulticastRequest", 0},
    /* MSG_TOK_STORE_STOP_MULTICAST_REPLY 11 */
    {11, "$$storeStopMulticastReply", 0},
    /* MSG_TOK_STORE_DONE_VAR_REQUEST 12 */
    {12, "$$storeDoneVarRequest", 0},
    /* MSG_TOK_STORE_DONE_VAR_REPLY 13 */
    {13, "$$storeDoneVarReply", 0},
    /* MSG_TOK_STORE_CLOSE_REQUEST 14 */
    {14, "$$storeCloseRequest", 0},
    /* MSG_TOK_STORE_CLOSE_REPLY 15 */
    {15, "$$storeCloseReply", 0},
    /* MSG_TOK_RESPONSE 16 */
    {16, "$$storeResponse", 1},
    /* MSG_TOK_ID 17 */
    {17, "$$storeId", 1},
    /* MSG_TOK_NAME 18 */
    {18, "$$storeName", 1},
    /* MSG_TOK_VALUE 19 */
    {19, "$$storeValue", 1},
    /* MSG_TOK_VAR_DEFINITION 20 */
    {20, "$$storeVarDefinition", 1},
    /* MSG_TOK_TYPE_DEFINITION 21 */
    {21, "$$storeTypeDefinition", 1},
    /* MSG_TOK_SHMEM_NAME 22 */
    {22, "$$storeShmemName", 1},
    /* MSG_TOK_SHMEM_ID 23 */
    {23, "$$storeShmemId", 1},
    /* MSG_TOK_SHMEM_SIZE 24 */
    {24, "$$storeShmemSize", 1},
    /* MSG_TOK_SHMEM_PID 25 */
    {25, "$$storeShmemPID", 1},
    /* MSG_TOK_SHMEM_VAR_OFFSET 26 */
    {26, "$$storeShmemVarOffset", 1},
    /* MSG_TOK_SHMEM_VAR_HEADER_OFFSET 27 */
    {27, "$$storeShmemVarHeaderOffset", 1},
    /* MSG_TOK_SYNC_SEM_ID 28 */
    {28, "$$storeSyncSemId", 1},
    /* MSG_TOK_SEM_POOL_NAME 29 */
    {29, "$$storeSemPoolName", 1},
    /* MSG_TOK_SEM_POOL_SIZE 30 */
    {30, "$$storeSemPoolSize", 1},
    /* MSG_TOK_STORE_PID 31 */
    {31, "$$storePid", 1},
    /* MSG_TOK_STORE_ERROR_REPLY 32 */
    {32, "$$storeErrorReply", 0},
    /* MSG_TOK_MESSAGE_ID 33 */
    {33, "$$storeMessageId", 1},
    /* MSG_TOK_SHMEM_VAR_ID 34 */
    {34, "$$storeShmemVarId", 1},
    /* MSG_TOK_SHMEM_VAR_SIZE 35 */
    {35, "$$storeShmemVarSize", 1},
    /* MSG_TOK_SYNC_SEM_ALLOCATE 36 */
    {36, "$$storeSyncSemAllocate", 0},
    /* MSG_TOK_MULTICAST_REQUIRED 37 */
    {37, "$$storeMulticastRequired", 0},
    /* MSG_TOK_VAR_MULTICAST_ADDRESS 38 */
    {38, "$$storeMulticastAddress", 1},
    /* MSG_TOK_VAR_MULTICAST_PORT 39 */
    {39, "$$storeMulticastPort", 1},
    /* MSG_TOK_LIST                                   40 */
    {40, "$$storeList", 1},
    /* MSG_TOK_STORE_GET_CATALOG_REQUEST              41 */
    {41, "$$storeGetCatalogRequest", 0},
    /* MSG_TOK_STORE_GET_CATALOG_REPLY                42 */
    {42, "$$storeGetCatalogReply", 0},
    /* MSG_TOK_STORE_GET_VAR_LIST_REQUEST             43 */
    {43, "$$storeGetVarListRequest", 0},
    /* MSG_TOK_STORE_GET_VAR_LIST_REPLY               44 */
    {44, "$$storeGetVarListReply", 0},
    /* MSG_TOK_STORE_GET_VAR_STATUS_REQUEST           45 */
    {45, "$$storeGetVarStatusRequest", 0},
    /* MSG_TOK_STORE_GET_VAR_STATUS_REPLY             46 */
    {46, "$$storeGetVarStatusReply", 0},
    /* MSG_TOK_STORE_GET_VAR_VALUE_REQUEST            47 */
    {47, "$$storeGetVarValueRequest", 0},
    /* MSG_TOK_STORE_GET_VAR_VALUE_REPLY              48 */
    {48, "$$storeGetVarValueReply", 0},
    /* MSG_TOK_STORE_SET_VAR_VALUE_REQUEST            49 */
    {49, "$$storeSetVarValueRequest", 0},
    /* MSG_TOK_STORE_SET_VAR_VALUE_REPLY              50 */
    {50, "$$storeSetVarValueReply", 0},
    /* MSG_TOK_LOCAL_LOOKUP                           51 */
    {51, "$$storeLookupLocal", 0},
    /* MSG_TOK_ITEM_TYPE_VAR                          52 */
    {52, "$$storeItemTypeVar", 0},
    /* MSG_TOK_ITEM_TYPE_TYPE                         53 */
    {53, "$$storeItemTypeType", 0},
    /* MSG_TOK_ITEM_TYPE_CONST                        54 */
    {54, "$$storeItemTypeConst", 0},
    /* MSG_TOK_STORE_LOOKUP_FIELD_REQUEST             55 */
    {55, "$$storeLookupFieldRequest", 0},
    /* MSG_TOK_STORE_LOOKUP_FIELD_REPLY               56 */
    {56, "$$storeLookupFieldReply", 0},
    /* MSG_TOK_SYNC_SYSVSEM_ID                        57 */     
    {57, "$$storeSyncSysvSemId", 1},             
    /* MSG_TOK_STORE_VAR_QUEUE_REQUEST                58 */
    {58, "$$storeVarQueueRequest", 0},
    /* MSG_TOK_STORE_VAR_QUEUE_REPLY                  59 */
    {59, "$$storeVarQueueReply", 0},
    {-1, "$$", 0}
};

MSG_TABLE_ENTRY msgTable [] = {    
    /* MSG_STORE_OPEN_REQUEST 0 */
    {0, 1, 
        {{MSG_TOK_STORE_OPEN_REQUEST, 1},
	 {-1, 0}}},
    /* MSG_STORE_OPEN_REPLY 1 */
    {1, 6, 
        {{MSG_TOK_STORE_OPEN_REPLY, 1},
	 {MSG_TOK_STORE_PID, 1},
	 {MSG_TOK_SHMEM_NAME, 1},
	 {MSG_TOK_SHMEM_SIZE, 1},
	 {MSG_TOK_SEM_POOL_NAME, 1},
	 {MSG_TOK_SEM_POOL_SIZE, 1},
	 {-1, 0}}},
    /* MSG_STORE_REGISTER_CONST_REQUEST 2 */
    {2, 3, 
        {{MSG_TOK_STORE_REGISTER_CONST_REQUEST, 1},
	 {MSG_TOK_NAME, 1},
	 {MSG_TOK_VALUE, 1},
	 {-1, 0}}},
    /* MSG_STORE_REGISTER_CONST_REPLY 3 */
    {3, 2, 
        {{MSG_TOK_STORE_REGISTER_CONST_REPLY, 1},
	 {MSG_TOK_RESPONSE, 1},
	 {-1, 0}}},
    /* MSG_STORE_REGISTER_TYPE_REQUEST 4 */
    {4, 2, 
        {{MSG_TOK_STORE_REGISTER_TYPE_REQUEST, 1},
	 {MSG_TOK_TYPE_DEFINITION, 1},
	 {-1, 0}}},
    /* MSG_STORE_REGISTER_TYPE_REPLY 5 */
    {5, 2, 
        {{MSG_TOK_STORE_REGISTER_TYPE_REPLY, 1},
	 {MSG_TOK_RESPONSE, 1},
	 {-1, 0}}},
    /* MSG_STORE_START_MULTICAST_REQUEST 6 */
    {6, 2, 
        {{MSG_TOK_STORE_START_MULTICAST_REQUEST, 1},
	 {MSG_TOK_VAR_DEFINITION, 1},
	 {-1, 0}}},
    /* MSG_STORE_START_MULTICAST_REPLY 7 */
    {7, 1, 
        {{MSG_TOK_STORE_START_MULTICAST_REPLY, 1},
	 {-1, 0}}},
    /* MSG_STORE_LOOKUP_VAR_REQUEST 8 */
    {8, 4, 
        {{MSG_TOK_STORE_LOOKUP_VAR_REQUEST, 1},
	 {MSG_TOK_VAR_DEFINITION, 1},
	 {MSG_TOK_TYPE_DEFINITION, 0},
	 {MSG_TOK_LOCAL_LOOKUP, 0},
	 {-1, 0}}},
    /* MSG_STORE_LOOKUP_VAR_REPLY 9 */
	{9, 15, 
        {{MSG_TOK_STORE_LOOKUP_VAR_REPLY, 1},
	 {MSG_TOK_SHMEM_NAME, 1},
	 {MSG_TOK_SHMEM_ID, 1},
	 {MSG_TOK_SHMEM_SIZE, 1},
	 {MSG_TOK_SHMEM_PID, 1},
	 {MSG_TOK_SHMEM_VAR_OFFSET, 1},
	 {MSG_TOK_SHMEM_VAR_HEADER_OFFSET, 1},
	 {MSG_TOK_SHMEM_VAR_ID, 1},
	 {MSG_TOK_SHMEM_VAR_SIZE, 1},
	 {MSG_TOK_SYNC_SEM_ID, 0},
			{MSG_TOK_SYNC_SYSVSEM_ID, 0},
	 {MSG_TOK_VAR_DEFINITION, 1},
	 {MSG_TOK_NAME, 1},
	 {MSG_TOK_VAR_MULTICAST_ADDRESS, 1},
	 {MSG_TOK_VAR_MULTICAST_PORT, 1},
	 {-1, 0}}},
    /* MSG_STORE_STOP_MULTICAST_REQUEST 10 */
    {10, 2, 
        {{MSG_TOK_STORE_STOP_MULTICAST_REQUEST, 1},
	 {MSG_TOK_VAR_DEFINITION, 1},
	 {-1, 0}}},
    /* MSG_STORE_STOP_MULTICAST_REPLY 11 */
    {11, 1,
        {{MSG_TOK_STORE_STOP_MULTICAST_REPLY, 1},
	 {-1, 0}}},
    /* MSG_STORE_DONE_VAR_REQUEST 12 */
    {12, 3, 
        {{MSG_TOK_STORE_DONE_VAR_REQUEST, 1},
	 {MSG_TOK_NAME, 1},
	 {MSG_TOK_SYNC_SEM_ID, 1},
	 {-1, 0}}},
    /* MSG_STORE_DONE_VAR_REPLY 13 */
    {13, 2, 
        {{MSG_TOK_STORE_DONE_VAR_REPLY, 1},
	 {MSG_TOK_RESPONSE, 1},
	 {-1, 0}}},
    /* MSG_STORE_CLOSE_REQUEST 14 */
    {14, 2, 
        {{MSG_TOK_STORE_CLOSE_REQUEST, 1},
	 {MSG_TOK_ID, 1},
	 {-1, 0}}},
    /* MSG_STORE_CLOSE_REPLY 15 */
    {15, 2, 
        {{MSG_TOK_STORE_CLOSE_REPLY, 1},
	 {MSG_TOK_RESPONSE, 1},
	 {-1, 0}}},
    /* MSG_STORE_ERROR_REPLY 16 */
    {16, 3, 
        {{MSG_TOK_STORE_ERROR_REPLY, 1},
	 {MSG_TOK_RESPONSE, 1},
	 {MSG_TOK_MESSAGE_ID, 1},
	 {-1, 0}}},
    /* MSG_STORE_GET_CATALOG_REQUEST                  17 */
    {17, 1, 
        {{MSG_TOK_STORE_GET_CATALOG_REQUEST, 1},
	 {-1, 0}}},
    /* MSG_STORE_GET_CATALOG_REPLY                    18 */
    {18, 2, 
        {{MSG_TOK_STORE_GET_CATALOG_REPLY, 1},
	 {MSG_TOK_NAME, 1},
	 {-1, 0}}},
    /* MSG_STORE_GET_VAR_LIST_REQUEST                 19 */
    {19, 4, 
        {{MSG_TOK_STORE_GET_VAR_LIST_REQUEST, 1},
         {MSG_TOK_ITEM_TYPE_VAR, 0},
         {MSG_TOK_ITEM_TYPE_TYPE, 0},
         {MSG_TOK_ITEM_TYPE_CONST, 0},
	 {-1, 0}}},
    /* MSG_STORE_GET_VAR_LIST_REPLY                   20 */
    {20, 2, 
        {{MSG_TOK_STORE_GET_VAR_LIST_REPLY, 1},
	 {MSG_TOK_LIST, 0},
	 {-1, 0}}},
    /* MSG_STORE_GET_VAR_STATUS_REQUEST               21 */
    {21, 5, 
        {{MSG_TOK_STORE_GET_VAR_STATUS_REQUEST, 1},
	 {MSG_TOK_NAME, 1},
         {MSG_TOK_ITEM_TYPE_VAR, 0},
         {MSG_TOK_ITEM_TYPE_TYPE, 0},
         {MSG_TOK_ITEM_TYPE_CONST, 0},
	 {-1, 0}}},
    /* MSG_STORE_GET_VAR_STATUS_REPLY                 22 */
    {22, 2, 
        {{MSG_TOK_STORE_GET_VAR_STATUS_REPLY, 1},
	 {MSG_TOK_VALUE, 1},
	 {MSG_TOK_SHMEM_VAR_SIZE, 1},
	 {MSG_TOK_VAR_DEFINITION, 1},
	 {-1, 0}}},
    /* MSG_STORE_GET_VAR_VALUE_REQUEST                23 */
    {23, 6, 
        {{MSG_TOK_STORE_GET_VAR_VALUE_REQUEST, 1},
	 {MSG_TOK_NAME, 1},
	 {MSG_TOK_ID, 0},
         {MSG_TOK_ITEM_TYPE_VAR, 0},
         {MSG_TOK_ITEM_TYPE_TYPE, 0},
         {MSG_TOK_ITEM_TYPE_CONST, 0},
	 {-1, 0}}},
    /* MSG_STORE_GET_VAR_VALUE_REPLY                  24 */
    {24, 2, 
        {{MSG_TOK_STORE_GET_VAR_VALUE_REPLY, 1},
	 {MSG_TOK_VALUE, 1},
	 {-1, 0}}},
    /* MSG_STORE_SET_VAR_VALUE_REQUEST                25 */
    {25, 4, 
        {{MSG_TOK_STORE_SET_VAR_VALUE_REQUEST, 1},
	 {MSG_TOK_NAME, 1},
	 {MSG_TOK_VALUE, 1},
	 {MSG_TOK_ID, 0},
	 {-1, 0}}},
    /* MSG_STORE_SET_VAR_VALUE_REPLY                  26 */
    {26, 2, 
        {{MSG_TOK_STORE_SET_VAR_VALUE_REPLY, 1},
	 {MSG_TOK_RESPONSE, 1},
	 {-1, 0}}},
    /* MSG_STORE_LOOKUP_FIELD_REQUEST                 27 */
    {27, 2, 
        {{MSG_TOK_STORE_LOOKUP_FIELD_REQUEST, 1},
	 {MSG_TOK_NAME, 1},
	 {-1, 0}}},
    /* MSG_STORE_LOOKUP_FIELD_REPLY                   28 */
    {28, 2, 
        {{MSG_TOK_STORE_LOOKUP_FIELD_REPLY, 1},
	 {MSG_TOK_ID, 1},
	 {-1, 0}}},
    /* MSG_STORE_SET_VAR_QUEUE_REQUEST                29 */
    {29, 4, 
        {{MSG_TOK_STORE_SET_VAR_QUEUE_REQUEST, 1},
	 {MSG_TOK_NAME, 1},
	 {MSG_TOK_VALUE, 1},
	 {MSG_TOK_ID, 0},
	 {-1, 0}}},
    /* MSG_STORE_SET_VAR_QUEUE_REPLY                  30 */
    {30, 2, 
        {{MSG_TOK_STORE_SET_VAR_QUEUE_REPLY, 1},
	 {MSG_TOK_RESPONSE, 1},
	 {-1, 0}}},
    {31, 1,
        {{-1, 0}}}
};

#ifdef TEST

char msgStr[1024];

int
main (void)
{
    /*
    char tok[1024];
    */
    MSG * mp;
    int i;

    if (gets (msgStr) == NULL)
        exit (0);

    /*
    while (get_next_message_token (msgStr, sep, &t1, &t2, tok) != -1)
        printf ("main: %s\n", tok);
    */

    if ((mp = parse_message (keyTable, msgStr)) == NULL) {
        printf ("Invalid message\n");
	return (-1);
    }

    printf ("%d parts identified\n", mp->numParams);
    for (i=0; i<mp->numParams; i++) {
        printf ("token id %d", mp->msgPart[i].id);
	if (keyTable[mp->msgPart[i].id].options)
	    printf (" : %s", mp->msgPart[i].val);
	printf ("\n");
    }
    if (identify_message (msgTable, mp) != -1) {
        printf ("message id = %d\n", mp->id);
    } else {
        printf ("invalid message\n");
    }
    return (0);
}

#endif
