
/***********************************************************************
 * store-main.h - header file for store-main module
 *
 * CSIRO MANUFACTURING SCIENCE & TECHNOLOGY
 * HIGH-SPEED SERIAL INTERFACE PROJECT
 *
 * $Id: store-main.h 2200 2007-11-23 05:46:38Z roy029 $
 *
 * Copyright (c) CSIRO Manufacturing Science & Technology.
 *
 ***********************************************************************
 */

#ifndef __store_main_h__
#define __store_main_h__

#include <rtx/thread.h>
#include <rtx/parse.h>
#include <rtx/list.h>
#include <rtx/mutex.h>
#include <rtx/inet.h>

#include "store-arch.h"
#include "store-ipc.h"
#include "ddx.h"

#define store_debug(x) \
    if (store->verbose) \
        rtx_message x

#define SIZE_VAR_INFO_LIST     256
#define STORE_CLIENTS_MAX      64
#define STORE_BUF_SIZE         8192

#define STORE_VAR_ENTRY_FIELD  1

typedef struct _var_info_item {
    int varId;
    int numClients;
    RtxParseVarTableEntry * vEntry;
    int flags;
    int offset;
    int headerOffset;
    char * multiAddr;
    int multiPort;
    STORE_SEM_T * lockSemP;
    RtxList * syncSemList;
    RtxThread * localProducerThreadId;
    DDX_STORE_ID mainVarStore;
    char buf[STORE_BUF_SIZE];
    struct _store * store;
    struct _var_info_item * next;
} VAR_INFO_ITEM;

typedef struct _store {
    int pid;
    RtxMutex mutex;
    RtxInet * server;
    int portNum;
    int forkFlag;
    int launchCatalog;
    int multicastTtl;
    RtxList * client;
    STORE_SHMEM_T * shmemP;
    STORE_SHMEM_T * semQShmemP;
    STORE_SEM_Q * semQ;
    char myHostName[64];
    char * incFileName;
    RtxList * varList;
    VAR_INFO_ITEM ** vars;
    STORE_ARCH_TYPE myArchType;
    STORE_ARCH myArch;
    RtxParseSymTabs * symTabs[STORE_ARCH_MAX_NUM];
    RtxParseSymTabs * mySymTabs;
    int curVarId;
    int sizeVarList;
    RtxList * catalogMsgQ;
    char buf[STORE_BUF_SIZE];
    int done;
    int verbose;
    int shmemSize;
    RtxThread * reqHandlerThread;
    RtxThread * semQHandlerThread;
    RtxThread * catalogHandlerThread;
    int semQHandlerThPrio;
    int semQHandlerDebug;
    DDX_STORE_ID catalog;
    char * catalogHostname;
    int catalogPortNum;
    RtxParseVar * headerVarP[STORE_ARCH_MAX_NUM];
    RtxParseVar * myHeaderVarP;
} STORE;

#endif
