
/***********************************************************************
 * store-ipc.h - header file for store-ipc module
 *
 * CSIRO MANUFACTURING SCIENCE & TECHNOLOGY
 * HIGH-SPEED SERIAL INTERFACE PROJECT
 * 
 * $Id: store-ipc.h 2200 2007-11-23 05:46:38Z roy029 $
 * 
 * Copyright (c) CSIRO Manufacturing Science & Technology.
 *
 ***********************************************************************
 */

#ifndef __store_ipc_h__
#define __store_ipc_h__

#include <rtx/time.h>
#include <rtx/inet.h>

#define STORE_SEM_POOL_NAME "store_sem_pool"
#define STORE_SEM_POOL_SIZE 128 /* More reasonable size, either for posix or sysv */

typedef struct _store_shmem_t {
  char            * name;
  pid_t           pid;
  int             id;
  unsigned char   * d;
  int             size;
} STORE_SHMEM_T;

typedef struct _store_sem_t {
  char            * name;
  int             id;
  int             semid;  /* only used by sysv implementation */
  pid_t           pid;    /* only used by posix/nptl implementation */
  void            * semp; /* only used by posix/nptl implementation */
  RtxInetConn     * conn; /* to keep track of who requested this semaphore */
} STORE_SEM_T;

int store_init_sem_pool (void);
int store_destroy_sem_pool (void);
STORE_SEM_T * store_create_sem (void);
int store_destroy_sem (STORE_SEM_T * semp);
int store_link_sem (STORE_SEM_T * semp);
int store_unlink_sem (STORE_SEM_T * semp);
int store_post_binary_sem (STORE_SEM_T * semp);
int store_post_sem (STORE_SEM_T * semp);
int store_wait_sem (STORE_SEM_T * semp);
int store_timed_wait_sem (STORE_SEM_T * semp, RtxTime * timeout);

int store_cleanup_ipc(void);
int store_init_shmem_table (void);
int store_destroy_shmem_table (void);
STORE_SHMEM_T * store_create_shmem (char * name, int size);
int store_destroy_shmem (STORE_SHMEM_T * shmemp);
STORE_SHMEM_T * store_link_shmem (char * name, int id, int size);
int store_unlink_shmem (STORE_SHMEM_T * shmemp);



#endif
