
/***********************************************************************
 * store-header.h - header file for store variable header structures
 *
 * CSIRO MANUFACTURING SCIENCE & TECHNOLOGY
 * HIGH-SPEED SERIAL INTERFACE PROJECT
 *
 * $Id: store-header.h 2200 2007-11-23 05:46:38Z roy029 $
 *
 * Copyright (c) CSIRO Manufacturing Science & Technology.
 *
 ***********************************************************************
 */

#ifndef __store_header_h__
#define __store_header_h__

#include <rtx/sem.h>

#define STORE_SHMEM_NAME       "store"
#define STORE_SHMEM_SIZE       65536
#define STORE_PORT_NUM         6002
#define STORE_XMLRPC_PORT_NUM  8001
#define CATALOG_PORT_NUM       6001

#define STORE_SEM_Q_SIZE       1024
#define STORE_SEM_Q_NAME       "storeSemQ"

#define STORE_SEM_Q_ACTION_POST     1
#define STORE_SEM_Q_ACTION_ADD      2
#define STORE_SEM_Q_ACTION_DEL      3
#define STORE_SEM_Q_ACTION_CLEAN    4

typedef struct _store_timespec {
    long tv_sec;
    long tv_nsec;
} STORE_TIMESPEC;

#define STORE_TIMESPEC_STR "struct _store_timespec { long tv_sec; long tv_nsec; } STORE_TIMESPEC;"

typedef struct _store_var_header {
    int count;
    int lockSemId;
    int lockSemSysVId;
    int producerSemId;
    int multicastRequired;
    int localVariable;		/* what is this used for? -MikeB */
    int queueLength;		/**< length > 0 indicates that variable is actually a queue */
    int shmOffset;		/**< shared memeory offset for data  */
    STORE_TIMESPEC ts;
} STORE_VAR_HEADER;

#define STORE_VAR_HEADER_STR "struct _store_var_header { int count; int lockSemId; int lockSemSysVId; int producerSemId; int multicastRequired; int localVariable; int queueLength; int shmOffset; STORE_TIMESPEC ts; } STORE_VAR_HEADER;"

#define STORE_VAR_HEADER_VAR "STORE_VAR_HEADER storeVarHeader;"

typedef struct _store_multicast_header {
    int count;
    int size;
    STORE_TIMESPEC ts;
} STORE_MULTICAST_HEADER;

#define STORE_MULTICAST_HEADER_STR "struct _store_multicast_header { int count; int size; STORE_TIMESPEC ts; } STORE_MULTICAST_HEADER;"

#define STORE_MULTICAST_HEADER_VAR "STORE_MULTICAST_HEADER store_multicast_header;"

typedef struct _store_sem_Q_element {
    int varId;
    int action;
    void * arg;
    STORE_TIMESPEC ts;
} STORE_SEM_Q_ELEMENT;

typedef struct _store_sem_Q {
    int nextEmptySlotInQ;
    int nextVarInQ;
    STORE_SEM_Q_ELEMENT Q[STORE_SEM_Q_SIZE];
    int QSize;
    RtxSem lockSem;
    RtxSem dataSem;
} STORE_SEM_Q;


#endif
