
/***********************************************************************
 * store-handlers.h - header file for store-handlers module
 *
 * CSIRO MANUFACTURING SCIENCE & TECHNOLOGY
 * HIGH-SPEED SERIAL INTERFACE PROJECT
 * 
 * $Id: store-handlers.h 2200 2007-11-23 05:46:38Z roy029 $
 * 
 * Copyright (c) CSIRO Manufacturing Science & Technology.
 *
 ***********************************************************************
 */

#ifndef __store_handlers_h__
#define __store_handlers_h__

int store_handle_open_request (MSG * mp, char * recvBuf, char * sendBuf, 
			       RtxInetConn * fromAddr, STORE * store);
int store_handle_register_const_request (MSG * mp, char * recvBuf, 
					 char * sendBuf, 
					 RtxInetConn * fromAddr,
					 STORE * store);
int store_handle_register_type_request (MSG * mp, char * recvBuf, 
					char * sendBuf, RtxInetConn * fromAddr,
					STORE * store);
int store_handle_register_var_request (MSG * mp, char * recvBuf, 
				       char * sendBuf, RtxInetConn * fromAddr,
				       STORE * store);
int store_handle_lookup_var_request (MSG * mp, char * recvBuf, char * sendBuf,
				     RtxInetConn * fromAddr, STORE * store);
int store_handle_deregister_var_request (MSG * mp, char * recvBuf, 
					 char * sendBuf, 
					 RtxInetConn * fromAddr,
					 STORE * store);
int store_handle_done_var_request (MSG * mp, char * recvBuf, 
				   char * sendBuf, RtxInetConn * fromAddr,
				   STORE * store);
int store_handle_close_request (MSG * mp, char * recvBuf, char * sendBuf,
				RtxInetConn * fromAddr, STORE * store);
int store_handle_get_catalog_request (MSG * mp, char * recvBuf,
				      char * sendBuf, RtxInetConn * fromAddr,
				      STORE * store);
int store_handle_get_var_list_request (MSG * mp, char * recvBuf,
				       char * sendBuf, RtxInetConn * fromAddr,
				       STORE * store);
int store_handle_get_var_status_request (MSG * mp, char * recvBuf,
					 char * sendBuf, 
					 RtxInetConn * fromAddr,
					 STORE * store);
int store_handle_get_var_value_request (MSG * mp, char * recvBuf, 
					char * sendBuf, RtxInetConn * fromAddr,
					STORE * store);
int store_handle_set_var_value_request (MSG * mp, char * recvBuf,
					char * sendBuf, RtxInetConn * fromAddr,
					STORE * store);
int store_handle_lookup_field_request (MSG * mp, char * recvBuf,
				       char * sendBuf, RtxInetConn * fromAddr,
				       STORE * store);
int store_handle_start_multicast_request (MSG * mp, char * recvBuf,
					  char * sendBuf,
					  RtxInetConn * fromAddr,
					  STORE * store);
int store_handle_stop_multicast_request (MSG * mp, char * recvBuf, 
					 char * sendBuf,
					 RtxInetConn * fromAddr,
					 STORE * store);
int store_handle_set_var_queue_request (MSG * mp, char * recvBuf,
					char * sendBuf, RtxInetConn * fromAddr,
					STORE * store);

void * store_local_producer_thread (VAR_INFO_ITEM * v);
RtxParseVarTableEntry * store_check_catalog (char * varName, STORE * store);

void store_clean_sync_semaphores(STORE * store, RtxInetConn * inetConn);

#endif
