
/***********************************************************************
 * store-common.h - header file for store-common module
 *
 * CSIRO MANUFACTURING SCIENCE & TECHNOLOGY
 * HIGH-SPEED SERIAL INTERFACE PROJECT
 * 
 * $Id: store-common.h 3068 2008-05-15 03:58:27Z roy029 $
 * 
 * Copyright (c) CSIRO Manufacturing Science & Technology.
 *
 ***********************************************************************
 */

#ifndef __store_common_h__
#define __store_common_h__

#include "store-msg.h"
#include "ddx.h"

int store_semQ_add (STORE_SEM_Q * q, int action, int varId, 
		    void * arg);

MSG * store_get_response (int sockfd, char * recvBuf, char * sendBuf,
			  int timeout, DDX_STORE_ID * storeId,
			  KEYWORD_TABLE_ENTRY * keyTable,
			  MSG_TABLE_ENTRY * msgTable,
			  const char * srcStr, int verbose);


/* macros for queue insertion and deletion */
#define DDX_STORE_QUEUE_MAX_COUNT 0x40000000

/* writes data to the head of a queue, uses the timestamp from the header */
int store_queue_write_entry(STORE_VAR_HEADER *svhp, 
			    void *queue_data, void *entry_data, unsigned int entry_size);

/* reads data from the tail of a queue (does not check for overflow),
   also updates timestamp in header from queue entry */
int store_queue_read_entry(STORE_VAR_HEADER *svhp, 
			   void *queue_data, void *entry_data, unsigned int entry_size, 
			   int tailCount);

/* reads the lastest entry inserted into the queue */
int store_queue_read_current(STORE_VAR_HEADER *svhp, 
			     void *queue_data, void *entry_data, unsigned int entry_size);


#endif
