
/***********************************************************************
 * store-arch.h - header file for store architectures
 *
 * CSIRO MANUFACTURING SCIENCE & TECHNOLOGY
 * HIGH-SPEED SERIAL INTERFACE PROJECT
 *
 * $Id: store-arch.h 3842 2008-08-21 08:36:44Z roy029 $
 *
 * Copyright (c) CSIRO Manufacturing Science & Technology.
 *
 ***********************************************************************
 */

#ifndef __store_arch_h__
#define __store_arch_h__

typedef enum _store_arch_types {
  STORE_ARCH_X86_LYNXOS,
  STORE_ARCH_SPARC_SOLARIS,
  STORE_ARCH_X86_QNXRTP,
  STORE_ARCH_ARM_VERDEX,
  STORE_ARCH_MAX_NUM
} STORE_ARCH_TYPE;

typedef struct _store_arch {
    unsigned char swapword[4];
    int dataSize[8];
    int dataAlign[8];
} STORE_ARCH;

extern STORE_ARCH storeArchs[];

int store_get_arch (STORE_ARCH * arch);

#endif
